function [data,st] = msh_UserMesh(data,execute_mode,fUserMesh)
    %% INPUT
    if exist(fUserMesh)~=2
        msg = 'User mesh file cannot be found';
        f_display_error(execute_mode,msg);
    end

    [INP,msg] = fopen(fUserMesh,'r+');
    if INP==-1
        f_display_error(execute_mode,msg);
    end

    %% MAIN
    % Nodes: id xcoord ycoord zcoord
    num_sn = fscanf(INP,'%d',1);

    sn = zeros(num_sn,3);
    for cont_n = 1:num_sn
        nodeid(cont_n) = fscanf(INP,'%d',1);
        sn(cont_n,1) =   fscanf(INP,'%f',1);
        sn(cont_n,2) =   fscanf(INP,'%f',1);
        sn(cont_n,3) =   fscanf(INP,'%f',1);
    end
    if sort(nodeid)~=1:num_sn
        msg = 'Wrong mesh nodes indexes';
        f_display_error(execute_mode,msg);
    end

    % Elements: id num_nodes node1 ··· nodeN
    num_se = fscanf(INP,'%d',1);

    e_nodes_indexes = zeros(num_se,9);
    for cont_e = 1:num_se
        el(cont_e) =          fscanf(INP,'%d',1); % element index
        e_dim(cont_e) =       fscanf(INP,'%d',1); % element dimension
        e_nodes_num(cont_e) = fscanf(INP,'%d',1); % element number of nodes
        e_surf(cont_e) =      fscanf(INP,'%d',1); % element surface
        for cont_n = 1:e_nodes_num(cont_e)  % element nodes indexes
            e_nodes_indexes(cont_e,cont_n) = fscanf(INP,'%d',1);
        end
    end
    
    % Reorder elements according to surface numbering
    [e_surf,idx]=sort(e_surf,'ascend');
    el = 1:num_se;
    e_dim = e_dim(idx);
    e_nodes_num = e_nodes_num(idx);
    e_nodes_indexes=e_nodes_indexes(idx,:);

    st = fclose(INP);

    % checking if mesh format is ok (Proper mesh check is made later)
    st_check = zeros(5,1);
    if sort(el)~=1:num_se
        msg = 'Wrong mesh elements indexes';
        f_display_error(execute_mode,msg);
        st_check(1) = -1;
    end
    if ~isempty(find(e_dim~=2))
        msg = 'Wrong mesh element dimension';
        f_display_error(execute_mode,msg);
        st_check(2) = -1;
    end
    if ~isempty(find(e_nodes_num(find(e_nodes_num~=6))~=9))
        msg = 'Wrong number of nodes in mesh element';
        f_display_error(execute_mode,msg);
        st_check(3) = -1;
    end
    if sort(unique(e_surf))~=1:length(unique(e_surf))
        msg = 'Wrong number of surfaces in mesh';
        f_display_error(execute_mode,msg);
        st_check(4) = -1;
    end
    if nodeid~=sort(unique(e_nodes_indexes(find(e_nodes_indexes~=0))));
        msg = 'Element node index does not exist';
        f_display_error(execute_mode,msg);
        st_check(5) = -1;
    end
    
    se = [e_dim' e_nodes_num' e_surf' e_nodes_indexes];


    %% OUTPUT
    data.Mesh.sn = sn;
    data.Mesh.se = se;

    if min(st_check) == 0
        msg = 'User mesh opened successfully ...';
        switch execute_mode
            case 1; msgbox(msg) % GUI
            case 2; disp(msg) % command
        end
    elseif min(st_check) ==-1
        msg = 'Incorrect mesh format. User mesh cannot be saved.';
        switch execute_mode
            case 1; msgbox(msg) % GUI
            case 2; disp(msg) % command
        end
    end
end

function f_display_error(execute_mode,msg)
    switch execute_mode
        case 1 % GUI
            errordlg(msg, 'Alert', 'modal')
        case 2 % command 
            error(msg)
        otherwise
            error('Wrong execution mode selected.')
    end
    return
end
