function data = msh_MESH2D(data)

    % Save maximum frequency in Hz
    switch data.Frequencies.type
        case 1
            switch data.Frequencies.ref
                case 1
                    maxf = max(data.Frequencies.value)*data.Frequencies.ref_data(2)/data.Frequencies.ref_data(1)/(2*pi);
                case 2
                    maxf = max(data.Frequencies.value)*data.Frequencies.ref_data(1)/(2*pi);
                case 3
                    maxf = max(data.Frequencies.value)*data.Frequencies.ref_data(1);
                otherwise
                    error ('Invalid type of normalization')
            end
        case 2
            maxf = max(data.Frequencies.value)/(2*pi);
        case 3
            maxf = max(data.Frequencies.value);
        otherwise
            error ('Invalid type of frequency')
    end

    % Save mesh parameters to local variables
    ratio_R   = data.MeshOptions.ratio_R*ones(1,data.Soil.N);
    ratio_r   = data.MeshOptions.ratio_r*ones(1,data.Soil.N);
    add_D     = data.MeshOptions.ratio_D*ones(1,data.Soil.N);
    nepl_near = data.MeshOptions.nepl_near*ones(1,data.Soil.N);
    nelo_near = data.MeshOptions.nelo_near*ones(1,data.Soil.N);
    nepl_far  = data.MeshOptions.nepl_far*ones(1,data.Soil.N);
    nelo_far  = data.MeshOptions.nelo_far*ones(1,data.Soil.N);

    % Add mesh2d path
    addpath(data.MeshOptions.toolpath);

    % Generate surface mesh
    Nl = data.Soil.N;
    z = zeros(1,Nl);
    cs = zeros(1,Nl);
    for k=1:Nl
        z(k) = data.Soil.layer(k).z;
        cs(k) = data.Soil.layer(k).cs;
    end
    Np = data.PileGroup.N;
    phx = zeros(Np,3);
    ptx = zeros(Np,3);
    pd = zeros(1,Np);
    for k=1:Np
        phx(k,:) = data.PileGroup.Pile(k).xhead;
        ptx(k,:) = data.PileGroup.Pile(k).xtip;
        pd(k)    = data.PileGroup.Pile(k).Do;
    end
    [nx,en,enn,ed,es] = ...
        GenerateOneQuarterMesh_3D(Nl,z,data.Soil.bedrock,cs,...
        Np,phx,ptx,pd,...
        maxf,ratio_R,ratio_r,add_D,nepl_near,nelo_near,nepl_far,nelo_far);

    % Save surface mesh data
    data.Mesh.sn= nx;
    data.Mesh.se= [ed enn es en(:,[1:6]) zeros(length(ed),3)];
    
    disp('Surface mesh of free-surface and interfaces created ...')

end
