function [st] = WritePileConfigurationFile(PGT,fC)
    INP = fopen(fC,'w+');
    fprintf(INP,'%s \n',PGT.type);
    switch PGT.type
        case 'regular' % PileGroupType data: Regular group
            fprintf(INP,'%f %f \n',PGT.bx,PGT.by);
            fprintf(INP,'%d %d \n',PGT.Nx,PGT.Ny);
            fprintf(INP,'%f %f \n',PGT.sx,PGT.sy);
            fprintf(INP,'%f \n',PGT.l);
            fprintf(INP,'%d \n',PGT.Rake);
            fprintf(INP,'%d \n',PGT.RakeDirection);
            fprintf(INP,'%d \n',PGT.RakeAngle);
            fm = '%f %f %f %f \n';
            fprintf(INP,fm,PGT.Do(1),PGT.Di(1),PGT.E(1),PGT.rho(1));
        case 'generic'
            fprintf(INP,'%f %f \n',PGT.bx,PGT.by);
            fprintf(INP,'%f \n',Ntotal);
            fprintf(INP,'%s',pile_prop_input_option);
            switch pile_prop_input_option
                case 'rake'
                    % % 1 xtop ytop ztop rakeAngle rakeDirection
                    for idpil = 1:Ntotal
                        pil = fscanf(INP,'%d',1);
                        for ax = 1:3
                            PGT.PileHeadX(pil,ax) = fscanf(INP,'%f',1);
                        end
                        PGT.RakeAngle =     fscanf(INP,'%f',1);
                        PGT.RakeDirection = fscanf(INP,'%f',1);
                        fm = '%d %f %f %f %f \n';
                        Do = PGT.Do(pil);
                        Di = PGT.Di(pil);
                        E = PGT.E(pil);
                        rho = PGT.rho(pil);
                        fprintf(INP,fm,pil,Do,Di,E,rho);
                    end
                case 'coordinates'
                    % % 1 xtop ytop ztop xtip ytip ztip
                    for idpil = 1:Ntotal
                        for ax = 1:3
                            pil = fscanf(INP,'%d',1);
                            PGT.PileHeadX(pil,ax) = fscanf(INP,'%f',1);
                            PGT.PileTipX(pil,ax)  = fscanf(INP,'%f',1);
                        end
                        fm = '%d %f %f %f %f \n';
                        Do = PGT.Do(pil);
                        Di = PGT.Di(pil);
                        E = PGT.E(pil);
                        rho = PGT.rho(pil);
                        fprintf(INP,fm,pil,Do,Di,E,rho);
                    end
            end
%        case 2 % Other groups
            %PGT.Symmetry = 4;
            %PGT.sym_axis = 0;
        otherwise
            msg = 'Problem configuration requested is not implemented yet';
            f_display_error(execute_mode,msg);
    end
    st = fclose(INP);
end

function f_display_error(execute_mode,msg)
    switch execute_mode
        case 1 % GUI
            errordlg(msg, 'Alert', 'modal')
        case 2 % command 
            error(msg)
        otherwise
            error('Wrong execution mode selected.')
    end
    return
end
