function WriteMeshFile(data,fUserMesh)

    [INP,errmsg] = fopen(fUserMesh,'w+');

    sn = data.Mesh.sn;
    se = data.Mesh.se;

    % Nodes: id xcoord ycoord zcoord
    fprintf(INP,'%d\n\n',size(sn,1));

    for cont_n = 1:size(sn,1)
        fprintf(INP,'%d ',cont_n);
        fprintf(INP,'%f %f %f\n',sn(cont_n,1),sn(cont_n,2),sn(cont_n,3));
    end
    fprintf(INP,'\n');

    % Elements: id num_nodes node1 ··· nodeN
    fprintf(INP,'%d\n\n',size(se,1));

    for cont_e = 1:size(se,1)
        fprintf(INP,'%d ',cont_e); % element index
        fprintf(INP,'%d ',se(cont_e,1)); % element dimension
        fprintf(INP,'%d ',se(cont_e,2)); % element number of nodes
        fprintf(INP,'%d ',se(cont_e,3)); % element surface

        e_nodes_num = se(cont_e,2);
        for cont_n = 1:e_nodes_num
            fprintf(INP,'%d ',se(cont_e,3+cont_n));
        end
        fprintf(INP,'\n');
    end

    st = fclose(INP);

    if min(st) == 0
        disp('Mesh file creation succeded ...');
    elseif min(st) == -1
        disp('Mesh File creation failed.');
    end

end
