function [fC,fS,fW,fMO] = WriteInputDataFiles(data,execute_mode)
    %% INPUT
    CaseName = data.Name;
    Path =     data.Path;
    
    if isempty(CaseName)
        msg = 'Project Name incomplete';
        f_display_error(execute_mode,msg);
    end

    [folder_path,folder] = fileparts(Path);
    current_path = pwd;
    cd folder_path;
    if ~exist(folder,'dir')
        msg = 'Wrong path to directory';
        f_display_error(execute_mode,msg);
    end
    cd current_path;
    if folder~=CaseName
        msg = 'Wrong path to directory';
        f_display_error(execute_mode,msg);
    end
    if ~exist(CaseName,'dir')
        msg = strcat('''',CaseName,''' folder cannot be found.');
        f_display_error(execute_mode,msg);
    end
    addpath(Path)

    fC = fullfile(Path,'Configuration.dat');
    fS = fullfile(Path,'SoilStratigraphy.dat');
    fW = fullfile(Path,'Frequencies.dat');
    fMO = fullfile(Path,'MeshOptions.dat');

    prompt = 'Enter the project name: ';
    switch execute_mode
        case 1 % GUI
            if exist(fC,'file') || exist(fS,'file') || exist(fW,'file') || exist(fMO,'file')
                msg = 'File(s) already exist. Data may be lost.';
                warndlg(msg, 'Alert', 'modal')
            end
        case 2 % command
            if exist(fC,'file') || exist(fS,'file') || exist(fW,'file') || exist(fMO,'file')
                msg = 'File(s) already exist. Data may be lost.';
                warning(msg)
            end
        otherwise
            error('Wrong execution mode selected.')
    end

    %% Configuration data
    st(1) = WritePileConfigurationFile(data.PileGroupType,fC);
%     INP = fopen(fC,'r+');
%     PGT = data.PileGroupType;
%     fprintf(INP,'%s \n',PGT.type);
%     switch PGT.type
%         case 'regular' % PileGroupType data: Regular group
%             fprintf(INP,'%f %f \n',PGT.bx,PGT.by);
%             fprintf(INP,'%d %d \n',PGT.Nx,PGT.Ny);
%             fprintf(INP,'%f %f \n',PGT.sx,PGT.sy);
%             fprintf(INP,'%f \n',PGT.l);
%             fprintf(INP,'%d \n',PGT.Rake);
%             fprintf(INP,'%d \n',PGT.RakeDirection);
%             fprintf(INP,'%d \n',PGT.RakeAngle);
%             fm = '%f %f %f %f \n';
%             fprintf(INP,fm,PGT.Do(1),PGT.Di(1),PGT.E(1),PGT.rho(1));
%         case 'generic'
%             fprintf(INP,'%f %f \n',PGT.bx,PGT.by);
%             fprintf(INP,'%f \n',Ntotal);
%             fprintf(INP,'%s',pile_prop_input_option);
%             switch pile_prop_input_option
%                 case 'rake'
%                     % % 1 xtop ytop ztop rakeAngle rakeDirection
%                     for idpil = 1:Ntotal
%                         pil = fscanf(INP,'%d',1);
%                         for ax = 1:3
%                             PGT.PileHeadX(pil,ax) = fscanf(INP,'%f',1);
%                         end
%                         PGT.RakeAngle =     fscanf(INP,'%f',1);
%                         PGT.RakeDirection = fscanf(INP,'%f',1);
% 
%                         fm = '%d %f %f %f %f \n';
%                         Do = PGT.Do(pil);
%                         Di = PGT.Di(pil);
%                         E = PGT.E(pil);
%                         rho = PGT.rho(pil);
%                         fprintf(INP,fm,pil,Do,Di,E,rho);
%                     end
%                 case 'coordinates'
%                     % % 1 xtop ytop ztop xtip ytip ztip
%                     for idpil = 1:Ntotal
%                         for ax = 1:3
%                             pil = fscanf(INP,'%d',1);
%                             PGT.PileHeadX(pil,ax) = fscanf(INP,'%f',1);
%                             PGT.PileTipX(pil,ax)  = fscanf(INP,'%f',1);
%                         end
% 
%                         fm = '%d %f %f %f %f \n';
%                         Do = PGT.Do(pil);
%                         Di = PGT.Di(pil);
%                         E = PGT.E(pil);
%                         rho = PGT.rho(pil);
%                         fprintf(INP,fm,pil,Do,Di,E,rho);
%                     end
%             end
% %        case 2 % Other groups
%             %PGT.Symmetry = 4;
%             %PGT.sym_axis = 0;
%         otherwise
%             msg = 'Problem configuration requested is not implemented yet';
%             f_display_error(execute_mode,msg);
%     end
%     st(1) = fclose(INP);


    %% Stratigraphy
    st(2) = WriteSoilStratigraphyFile(data.Soil,fS);
%     INP = fopen(fS,'r+');
%     Soil = data.Soil;
%     fprintf(INP,'%d \n',Soil.N);
%     for iddom = 1:Soil.N
%         if iddom~=Soil.N || (iddom==Soil.N && ~Soil.bedrock)
%             name =    Soil.layer(iddom).name;
%             zdom =    Soil.layer(iddom).z;
%             mus =     Soil.layer(iddom).mu;
%             nus =     Soil.layer(iddom).nu;
%             rhos =    Soil.layer(iddom).rho;
%             xis =     Soil.layer(iddom).xi;
%             fm = '%s %f 0 %f %f %f %f \n';
%             fprintf(INP,fm,name,zdom,mus,nus,rhos,xis);
%         else
%             name_bedrock = Soil.layer(iddom).name;
%             zdom_bedrock = Soil.layer(iddom).z;
%             fprintf(INP,'%s %f 1 \n',name_bedrock,zdom_bedrock);
%         end
%     end
%     st(2) = fclose(INP);


    %% Frequencies
    st(3) = WriteFrequenciesFile(data.Frequencies,fW);
%     INP= fopen(fW,'r+');
%     W = data.Frequencies;
%     fprintf(INP,'%d \n',W.type);
%     fprintf(INP,'%d \n',length(W.value));
%     for idfreq = 1:length(W.value)
%         fprintf(INP,'%f ',W.value(idfreq));
%     end
%     fprintf(INP,'\n');
%     fprintf(INP,'%d\n',W.ref);
%     switch W.ref
%         case 1
%             fprintf(INP,'%f %f \n',W.ref_data(1),W.ref_data(2));
%         case {2,3}
%             fprintf(INP,'%f \n',W.ref_data(1));
%     end
%     st(3) = fclose(INP);


    %% Mesh Options
    st(4) = WriteMeshOptionsFile(data.MeshOptions,fMO);
%     INP = fopen(fMO,'r+');
%     Mopt = data.MeshOptions;
%     fprintf(INP,'%d\n',       Mopt.tool);
%     fprintf(INP,'%f %f \n',   Mopt.ratio_r,  Mopt.ratio_R);
%     fprintf(INP,'%f\n',       Mopt.ratio_D);
%     fprintf(INP,'%f %f %f \n',Mopt.nepl_near,Mopt.nepl_far,Mopt.nepd_pile);
%     fprintf(INP,'%f %f %f \n',Mopt.nelo_near,Mopt.nelo_far,Mopt.nelo_pile);
%     fprintf(INP,'%f \n',      Mopt.t);
%     fprintf(INP,'%f \n',      Mopt.tolerance);
%     st(4) = fclose(INP);
    % fclose returns 0 if successful or -1 if not
    switch execute_mode
        case 1 % GUI
            % st returns 0 if successful or -1 if not
            if min(st) == 0
                msgbox('File creation succeded.','Solver input files','modal');
            end
            if min(st) == -1
                msgbox('File creation failed.','Solver input files','modal');
            end
        case 2 % command
            for id = 1:4
                switch id
                    case 1; filename = fC;
                    case 2; filename = fS;
                    case 3; filename = fW;
                    case 4; filename = fMO;
                end
                if st(id)==0
                    fprintf('File %s creation succeded.\n',filename);
                else
                    st(id)
                    warning('File %s creation failed.\n',filename);
                end
            end
    end
end

function f_display_error(execute_mode,msg)
    switch execute_mode
        case 1 % GUI
            errordlg(msg, 'Alert', 'modal')
        case 2 % command 
            error(msg)
        otherwise
            error('Wrong execution mode selected.')
    end
    return
end
