function [nx,en,enn] = TransformToQuadratic(nxIn,enIn,ennIn,ed)

    % Transform linear elements to quadratic elements (assume all linear)
    % Note: quadrilateral to 9-node quadrilaterals.

    % Build edges (edge->nodes, edge->elements & element->edges)
    
    NElements = length(enIn(:,1));
    % Number of edges of each element
    ene = ennIn;
    ene(ene==2) = 1;

    NElements = length(enIn(:,1));
    en = enIn;
    en(NElements,9)=0;
    enn = ennIn;
    nx = [nxIn;zeros(5*NElements,3)]; % se puede redimensionar mejor (nº aristas (nodos centrales arista) + nº elementos quad4 (nodo central cara))

    h = waitbar(0,'Please wait...');

    for ke=1:NElements
        %
        % Line elements (line2 -> line3)
        %
        if ed(ke)==1 && enn(ke)==2
            NEdges = 1;
            Edge = [1,2];
            EdgeMidNode = [3];
            for kmn=1:NEdges
                % If midnode not assigned yet, build it.
                if en(ke,EdgeMidNode(kmn)) == 0
                    edge = sort(en(ke,Edge(kmn,:)));
                    xnew = mean(nxIn(edge,:));
                    newid = max(max(en))+1;
                    nx(newid,:) = xnew;
                    en(ke,EdgeMidNode(kmn)) = newid;
                    % Transfer this change to adjacent elements
                    for kej=(ke+1):NElements
                        % Line elements (line2 -> line3)
                        if ed(kej)==1 && enn(kej)==2
                            NEdgesj = 1;
                            Edgej = [1,2];
                            EdgeMidNodej = [3];
                            for kmnj=1:NEdgesj
                                edgej = sort(en(kej,Edgej(kmnj,:)));
                                if isequal(edge,edgej) && en(kej,EdgeMidNodej(kmnj)) == 0
                                    en(kej,EdgeMidNodej(kmnj)) = newid;
                                end
                            end
                        end
                        % Triangular elements (tri3 -> tri6)
                        if ed(kej)==2 && enn(kej)==3
                            NEdgesj = 3;
                            Edgej = [1,2;2,3;3,1];
                            EdgeMidNodej = [4,5,6];
                            for kmnj=1:NEdgesj
                                edgej = sort(en(kej,Edgej(kmnj,:)));
                                if isequal(edge,edgej) && en(kej,EdgeMidNodej(kmnj)) == 0
                                    en(kej,EdgeMidNodej(kmnj)) = newid;
                                end
                            end
                        end
                        % Quadrilateral elements (quad4 -> quad9)
                        if ed(kej)==2 && enn(kej)==4
                            NEdgesj = 4;
                            Edgej = [1,2;2,3;3,4;4,1];
                            EdgeMidNodej = [5,6,7,8];
                            for kmnj=1:NEdgesj
                                edgej = sort(en(kej,Edgej(kmnj,:)));
                                if isequal(edge,edgej) && en(kej,EdgeMidNodej(kmnj)) == 0
                                    en(kej,EdgeMidNodej(kmnj)) = newid;
                                end
                            end
                        end
                    end  
                end
            end
            % Element completely transformed
            enn(ke) = 3;
        end 
        %
        % Triangular elements (tri3 -> tri6)
        %
        if ed(ke)==2 && enn(ke)==3
            NEdges = 3;
            Edge = [1,2;2,3;3,1];
            EdgeMidNode = [4,5,6];
            for kmn=1:NEdges
                % If midnode not assigned yet, build it.
                if en(ke,EdgeMidNode(kmn)) == 0
                    edge = sort(en(ke,Edge(kmn,:)));
                    xnew = mean(nxIn(edge,:));
                    newid = max(max(en))+1;
                    nx(newid,:) = xnew;
                    en(ke,EdgeMidNode(kmn)) = newid;
                    % Transfer this change to adjacent elements
                    for kej=(ke+1):NElements
                        % Line elements (line2 -> line3)
                        if ed(kej)==1 && enn(kej)==2
                            NEdgesj = 1;
                            Edgej = [1,2];
                            EdgeMidNodej = [3];
                            for kmnj=1:NEdgesj
                                edgej = sort(en(kej,Edgej(kmnj,:)));
                                if isequal(edge,edgej) && en(kej,EdgeMidNodej(kmnj)) == 0
                                    en(kej,EdgeMidNodej(kmnj)) = newid;
                                end
                            end
                        end
                        % Triangular elements (tri3 -> tri6)
                        if ed(kej)==2 && enn(kej)==3
                            NEdgesj = 3;
                            Edgej = [1,2;2,3;3,1];
                            EdgeMidNodej = [4,5,6];
                            for kmnj=1:NEdgesj
                                edgej = sort(en(kej,Edgej(kmnj,:)));
                                if isequal(edge,edgej) && en(kej,EdgeMidNodej(kmnj)) == 0
                                    en(kej,EdgeMidNodej(kmnj)) = newid;
                                end
                            end
                        end
                        % Quadrilateral elements (quad4 -> quad9)
                        if ed(kej)==2 && enn(kej)==4
                            NEdgesj = 4;
                            Edgej = [1,2;2,3;3,4;4,1];
                            EdgeMidNodej = [5,6,7,8];
                            for kmnj=1:NEdgesj
                                edgej = sort(en(kej,Edgej(kmnj,:)));
                                if isequal(edge,edgej) && en(kej,EdgeMidNodej(kmnj)) == 0
                                    en(kej,EdgeMidNodej(kmnj)) = newid;
                                end
                            end
                        end
                    end  
                end
            end
            enn(ke) = 6;
        end
        %
        % Quadrilateral elements (quad4 -> quad9)
        %
        if ed(ke)==2 && enn(ke)==4
            NEdges = 4;
            Edge = [1,2;2,3;3,4;4,1];
            EdgeMidNode = [5,6,7,8];
            for kmn=1:NEdges
                % If midnode not assigned yet, build it.
                if en(ke,EdgeMidNode(kmn)) == 0
                    edge = sort(en(ke,Edge(kmn,:)));
                    xnew = mean(nxIn(edge,:));
                    newid = max(max(en))+1;
                    nx(newid,:) = xnew;
                    en(ke,EdgeMidNode(kmn)) = newid;
                    % Transfer this change to adjacent elements
                    for kej=(ke+1):NElements
                        % Line elements (line2 -> line3)
                        if ed(kej)==1 && enn(kej)==2
                            NEdgesj = 1;
                            Edgej = [1,2];
                            EdgeMidNodej = [3];
                            for kmnj=1:NEdgesj
                                edgej = en(kej,Edgej(kmnj,:));
                                if isequal(edge,edgej) && en(kej,EdgeMidNodej(kmnj)) == 0
                                    en(kej,EdgeMidNodej(kmnj)) = newid;
                                end
                            end
                        end
                        % Triangular elements (tri3 -> tri6)
                        if ed(kej)==2 && enn(kej)==3
                            NEdgesj = 3;
                            Edgej = [1,2;2,3;3,1];
                            EdgeMidNodej = [4,5,6];
                            for kmnj=1:NEdgesj
                                edgej = en(kej,Edgej(kmnj,:));
                                if isequal(edge,edgej) && en(kej,EdgeMidNodej(kmnj)) == 0
                                    en(kej,EdgeMidNodej(kmnj)) = newid;
                                end
                            end
                        end
                        % Quadrilateral elements (quad4 -> quad9)
                        if ed(kej)==2 && enn(kej)==4
                            NEdgesj = 4;
                            Edgej = [1,2;2,3;3,4;4,1];
                            EdgeMidNodej = [5,6,7,8];
                            for kmnj=1:NEdgesj
                                edgej = en(kej,Edgej(kmnj,:));
                                if isequal(edge,edgej) && en(kej,EdgeMidNodej(kmnj)) == 0
                                    en(kej,EdgeMidNodej(kmnj)) = newid;
                                end
                            end
                        end
                    end
                end
            end
            enn(ke) = 9;
        end

        if NElements >= 25
            waitbar(ke/NElements);
        end
        
    end
    nx = nx(1:max(max(en)),:);

    close(h)
%    delete(h)
end

