function [x,e] = SubdivideLine2(x1,x2,N)
%SubdivideLine2 
    xParent = [x1 x2];    % Coordinates of the parent element
    n       = length(x1);             % Dimension
    NNodes  = N+1;     % Number of nodes of the mesh
    NElements = N;
    % Coordinates of nodes
    x = zeros(n,NNodes);        % Coordinates of mesh nodes: x(coord,node)
    for k=1:N+1
        xi = -1+2*(k-1)/N;
        phi = [0.5*(1-xi) 0.5*(1+xi)];
        x(:,k) = xParent*phi';
    end
    % Connectivity elements->nodes
    e = zeros(2,NElements);
    for k=1:N
        e(1,k) = k;
        e(2,k) = k+1;
    end
end
