function varargout = SoilStratigraphy(varargin)
% SOILSTRATIGRAPHY MATLAB code for SoilStratigraphy.fig
%      SOILSTRATIGRAPHY, by itself, creates a new SOILSTRATIGRAPHY or raises the existing
%      singleton*.
%
%      H = SOILSTRATIGRAPHY returns the handle to a new SOILSTRATIGRAPHY or the handle to
%      the existing singleton*.
%
%      SOILSTRATIGRAPHY('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in SOILSTRATIGRAPHY.M with the given input arguments.
%
%      SOILSTRATIGRAPHY('Property','Value',...) creates a new SOILSTRATIGRAPHY or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before SoilStratigraphy_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to SoilStratigraphy_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help SoilStratigraphy

% Last Modified by GUIDE v2.5 20-Sep-2017 10:45:38

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @SoilStratigraphy_OpeningFcn, ...
                   'gui_OutputFcn',  @SoilStratigraphy_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before SoilStratigraphy is made visible.
function SoilStratigraphy_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to SoilStratigraphy (see VARARGIN)
if length(varargin)==1 && ~isempty(varargin{1})
    soil=varargin{1};
    % We will store the initialization data structure here
    handles.pushbuttonCancel.UserData = soil;
else
    LayerData(1) = struct('name','sand',... % Name of each layer stored in a cell array
                       'z',0,...            % Top coordinate (<=0) of each layer stored in an array
                       'mu',100.E6,...      % Shear modulus of each layer stored in an array
                       'nu',0.3,...         % Poisson's ratio of each layer stored in an array
                       'rho',2000,...       % Density of each layer stored in an array
                       'xi',0.05,...        % Damping ratio of each layer stored in an array  
                       'cs',sqrt(100.E6/2000));  % Shear wave velocity
                   
    soil = struct('N',1,...                 % Number of layers
                  'layer',LayerData, ...    % A vector with data structures of layer data
                  'bedrock',false);         % Is last layer a bedrock           
    % We will store the initialization data structure here in case cancel
    handles.pushbuttonCancel.UserData = [];
end

% Check initialization
soil.layer(1).z=0;
% We will store all data in figure1.UserData                      
handles.figure1.UserData=soil;

handles.editN.String=sprintf('%g',round(soil.N));

listString=sprintf("%d (%s) at %g",1,soil.layer(1).name,soil.layer(1).z);
for kl = 2:soil.N
    tmpstr=sprintf("|%d (%s) at %g",kl,soil.layer(kl).name,soil.layer(kl).z);
    listString=strcat(listString,tmpstr);
end
handles.listboxLayers.String=listString;

handles.listboxLayers.Value=1;
handles.editz.Enable='off';

active = handles.listboxLayers.Value;
handles.editname.String=sprintf('%s',soil.layer(active).name);                      
handles.editz.String   =sprintf('%g',soil.layer(active).z);                      
handles.editmu.String  =sprintf('%g',soil.layer(active).mu);
handles.editnu.String  =sprintf('%g',soil.layer(active).nu);
handles.editrho.String =sprintf('%g',soil.layer(active).rho);
handles.editxi.String  =sprintf('%g',soil.layer(active).xi);

handles.checkboxbedrock.Value = soil.bedrock;

plotStratigraphy(handles)

handles.pushbuttonAccept.UserData = 0;

% Choose default command line output for SoilStratigraphy
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);
movegui(hObject,'center');

% UIWAIT makes SoilStratigraphy wait for user response (see UIRESUME)
uiwait(handles.figure1);



function writeListLayers(handles)
soil = handles.figure1.UserData;                   
listString=sprintf("%d (%s) at %g",1,soil.layer(1).name,soil.layer(1).z);
for kl = 2:soil.N
    tmpstr=sprintf("|%d (%s) at %g",kl,soil.layer(kl).name,soil.layer(kl).z);
    listString=strcat(listString,tmpstr);
end
handles.listboxLayers.String=listString;



function plotStratigraphy(handles)
    % Copy data to local variables
    soil = handles.figure1.UserData;
    % Initialize
    cla(handles.axes1)
    hold on
    % Local variables
    for kl=1:soil.N
        z(kl)=soil.layer(kl).z;
        cs(kl) = sqrt(soil.layer(kl).mu/soil.layer(kl).rho);
    end
    % Bounding box
    xl=max(cs)-min(cs);
    yl=max(z)-min(z);
    if xl==0
        xl=1;
    end
    if yl==0
        yl=1;
    end
    % Draw each layer
    for kl=1:soil.N
        % Top surface of the layer
        x = [min(cs)-0.2*xl max(cs)+0.2*xl];
        y = [z(kl) z(kl)];
        plot(x,y,'k-');
        % cs line
        x = [cs(kl) cs(kl)];
        if kl==soil.N
            y = [z(kl) min(z)-0.2*yl];
        else
            y = [z(kl) z(kl+1)];
        end        
        if ~isnan(cs(kl))
            plot(x,y,'b-') 
        end        
        % Label text
        if handles.listboxLayers.Value==kl
            strfont='bold';
        else
            strfont='normal';
        end
        if soil.bedrock==true && kl==soil.N
            strcolor=[0.6 0.3 0];
        else
            strcolor='none';
        end
        text(mean(cs(find(~isnan(cs)))),mean(y),soil.layer(kl).name,...
            'HorizontalAlignment','center',...
            'FontWeight',strfont,...
            'BackgroundColor',strcolor);
    end
    set(handles.axes1,'XLim',[min(cs)-0.2*xl max(cs)+0.2*xl])
    set(handles.axes1,'YLim',[min( z)-0.2*yl max( z)+0.2*yl])
    set(handles.axes1,'Box','on')
    xlabel(handles.axes1,'c_s')
    ylabel(handles.axes1,'depth')


function updateEdit(handles)
active = get(handles.listboxLayers,'Value');
soil = handles.figure1.UserData;
if soil.bedrock && active == soil.N
    handles.editname.String=sprintf('%s',soil.layer(active).name);
    handles.editz.String   =sprintf('%g',soil.layer(active).z);                     
    handles.editmu.String  ='';
    handles.editnu.String  ='';
    handles.editrho.String ='';
    handles.editxi.String  ='';
    handles.figure1.UserData.layer(active).mu = NaN;
    handles.figure1.UserData.layer(active).nu = NaN;
    handles.figure1.UserData.layer(active).rho = NaN;
    handles.figure1.UserData.layer(active).xi = NaN;
    handles.editname.BackgroundColor=get(0,'defaultUicontrolBackgroundColor');
    handles.editz.BackgroundColor   =get(0,'defaultUicontrolBackgroundColor');            
    handles.editmu.BackgroundColor  =get(0,'defaultUicontrolBackgroundColor');
    handles.editnu.BackgroundColor  =get(0,'defaultUicontrolBackgroundColor');
    handles.editrho.BackgroundColor =get(0,'defaultUicontrolBackgroundColor');
    handles.editxi.BackgroundColor  =get(0,'defaultUicontrolBackgroundColor');
    handles.editname.Enable='on';
    handles.editz.Enable   ='on';            
    handles.editmu.Enable  ='off';
    handles.editnu.Enable  ='off';
    handles.editrho.Enable ='off';
    handles.editxi.Enable  ='off';
else
    handles.editname.String=sprintf('%s',soil.layer(active).name);
    handles.editz.String   =sprintf('%g',soil.layer(active).z);                      
    handles.editmu.String  =sprintf('%g',soil.layer(active).mu);
    handles.editnu.String  =sprintf('%g',soil.layer(active).nu);
    handles.editrho.String =sprintf('%g',soil.layer(active).rho);
    handles.editxi.String  =sprintf('%g',soil.layer(active).xi);
    if active==1
        handles.editz.Enable='off';
    else
        handles.editz.Enable='on';
    end
    handles.editname.BackgroundColor=get(0,'defaultUicontrolBackgroundColor');
    handles.editz.BackgroundColor   =get(0,'defaultUicontrolBackgroundColor');            
    handles.editmu.BackgroundColor  =get(0,'defaultUicontrolBackgroundColor');
    handles.editnu.BackgroundColor  =get(0,'defaultUicontrolBackgroundColor');
    handles.editrho.BackgroundColor =get(0,'defaultUicontrolBackgroundColor');
    handles.editxi.BackgroundColor  =get(0,'defaultUicontrolBackgroundColor');
    handles.editname.Enable='on';
    handles.editz.Enable   ='on';            
    handles.editmu.Enable  ='on';
    handles.editnu.Enable  ='on';
    handles.editrho.Enable ='on';
    handles.editxi.Enable  ='on';
end        
    
    

% --- Outputs from this function are returned to the command line.
function varargout = SoilStratigraphy_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
if handles.pushbuttonAccept.UserData==1
    soil = handles.figure1.UserData;
    for kl=1:soil.N
        soil.layer(kl).cs = sqrt(soil.layer(kl).mu/soil.layer(kl).rho);
    end
    varargout{1} = soil;
else
    varargout{1} = handles.pushbuttonCancel.UserData;
end
delete(handles.figure1);


% --- Executes on selection change in listboxLayers.
function listboxLayers_Callback(hObject, eventdata, handles)
% hObject    handle to listboxLayers (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns listboxLayers contents as cell array
%        contents{get(hObject,'Value')} returns selected item from listboxLayers
plotStratigraphy(handles);
updateEdit(handles);


% --- Executes during object creation, after setting all properties.
function listboxLayers_CreateFcn(hObject, eventdata, handles)
% hObject    handle to listboxLayers (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbuttonAccept.
function pushbuttonAccept_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonAccept (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
set(hObject,'UserData',1)
figure1_CloseRequestFcn(handles.figure1, eventdata, handles)


% --- Executes on button press in pushbuttonCancel.
function pushbuttonCancel_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonCancel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
figure1_CloseRequestFcn(handles.figure1, eventdata, handles)

% --- Executes on button press in pushbuttonAdd.
function pushbuttonAdd_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonAdd (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
active = handles.listboxLayers.Value;
soil = handles.figure1.UserData;
soil_mod = soil;
kln=1;
for kl=1:soil.N
    soil_mod.layer(kln)=soil.layer(kl);
    kln=kln+1;
    if kl==active
        kln=kln+1;
    end
end
soil_mod.layer(active+1)=soil.layer(active);
soil_mod.N = soil.N+1;
if active+1==soil_mod.N
    soil_mod.layer(active+1).z = soil_mod.layer(active).z-1;
else
    soil_mod.layer(active+1).z = 0.5*(soil_mod.layer(active).z+soil_mod.layer(active+2).z);
end
handles.listboxLayers.Value=active+1;
active = active+1;
soil = soil_mod;
handles.editN.String=sprintf('%g',soil.N);
handles.editname.String=sprintf('%s',soil.layer(active).name);
handles.editz.String   =sprintf('%g',soil.layer(active).z);                      
handles.editmu.String  =sprintf('%g',soil.layer(active).mu);
handles.editnu.String  =sprintf('%g',soil.layer(active).nu);
handles.editrho.String =sprintf('%g',soil.layer(active).rho);
handles.editxi.String  =sprintf('%g',soil.layer(active).xi);
handles.editname.BackgroundColor=get(0,'defaultUicontrolBackgroundColor');
handles.editz.BackgroundColor   =get(0,'defaultUicontrolBackgroundColor');                  
handles.editmu.BackgroundColor  =get(0,'defaultUicontrolBackgroundColor');
handles.editnu.BackgroundColor  =get(0,'defaultUicontrolBackgroundColor');
handles.editrho.BackgroundColor =get(0,'defaultUicontrolBackgroundColor');
handles.editxi.BackgroundColor  =get(0,'defaultUicontrolBackgroundColor');
if active==1
    handles.editz.Enable='off';
else
    handles.editz.Enable='on';
end    
handles.figure1.UserData = soil;
writeListLayers(handles);
plotStratigraphy(handles);    







function editmu_Callback(hObject, eventdata, handles)
% hObject    handle to editmu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editmu as text
%        str2double(get(hObject,'String')) returns contents of editmu as a double
set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
if CheckNumericEdit(0,'<',hObject,'<',Inf,false)
    active = handles.listboxLayers.Value;
    handles.figure1.UserData.layer(active).mu=str2double(get(hObject,'String'));
    plotStratigraphy(handles);
else
    cla(handles.axes1)
end


% --- Executes during object creation, after setting all properties.
function editmu_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editmu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function editnu_Callback(hObject, eventdata, handles)
% hObject    handle to editnu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editnu as text
%        str2double(get(hObject,'String')) returns contents of editnu as a double
set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
if CheckNumericEdit(-1,'<',hObject,'<',0.5,false)
    active = handles.listboxLayers.Value;
    handles.figure1.UserData.layer(active).nu=str2double(get(hObject,'String'));
    plotStratigraphy(handles);
else
    cla(handles.axes1)
end

% --- Executes during object creation, after setting all properties.
function editnu_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editnu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function editrho_Callback(hObject, eventdata, handles)
% hObject    handle to editrho (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editrho as text
%        str2double(get(hObject,'String')) returns contents of editrho as a double
set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
if CheckNumericEdit(0,'<=',hObject,'<',Inf,false)
    active = handles.listboxLayers.Value;
    handles.figure1.UserData.layer(active).rho=str2double(get(hObject,'String'));
    plotStratigraphy(handles);
else
    cla(handles.axes1)
end

% --- Executes during object creation, after setting all properties.
function editrho_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editrho (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function editxi_Callback(hObject, eventdata, handles)
% hObject    handle to editxi (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editxi as text
%        str2double(get(hObject,'String')) returns contents of editxi as a double
set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
if CheckNumericEdit(0,'<=',hObject,'<',1,false)
    active = handles.listboxLayers.Value;
    handles.figure1.UserData.layer(active).xi=str2double(get(hObject,'String'));
    plotStratigraphy(handles);
else
    cla(handles.axes1)
end

% --- Executes during object creation, after setting all properties.
function editxi_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editxi (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in checkboxbedrock.
function checkboxbedrock_Callback(hObject, eventdata, handles)
% hObject    handle to checkboxbedrock (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkboxbedrock
if handles.figure1.UserData.N>1
    handles.figure1.UserData.bedrock = get(hObject,'Value');
    if handles.figure1.UserData.bedrock
        handles.figure1.UserData.layer(handles.figure1.UserData.N).mu = NaN;
        handles.figure1.UserData.layer(handles.figure1.UserData.N).nu = NaN;
        handles.figure1.UserData.layer(handles.figure1.UserData.N).rho = NaN;
        handles.figure1.UserData.layer(handles.figure1.UserData.N).xi = NaN;    
    end
    plotStratigraphy(handles);
    updateEdit(handles);
else
    set(hObject,'Value',false);
    warndlg('Bedrock can not be defined in a homogeneous soil','Warning','modal')
end

function editz_Callback(hObject, eventdata, handles)
% hObject    handle to editz (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editz as text
%        str2double(get(hObject,'String')) returns contents of editz as a double
set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
if CheckNumericEdit(-Inf,'<',hObject,'<=',0,false)
    active = handles.listboxLayers.Value;
    soil = handles.figure1.UserData;
    for kl=1:soil.N
        z(kl)=soil.layer(kl).z;
    end 
    repeat=false;
    for kl=1:soil.N
        if kl~=active
            if z(kl)==str2double(get(hObject,'String'))
                repeat=true;
            end
        end
    end
    if repeat
        set(hObject,'BackgroundColor',[1 0 0]);
        cla(handles.axes1)
    else
        set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
        active = handles.listboxLayers.Value;
        handles.figure1.UserData.layer(active).z=str2double(get(hObject,'String'));
        reorderLayers(handles);
        plotStratigraphy(handles);
    end
else
    cla(handles.axes1)
end




function reorderLayers(handles)
    active = handles.listboxLayers.Value;
    soil = handles.figure1.UserData;
    soil_mod = soil;
    for kl=1:soil.N
        z(kl)=soil.layer(kl).z;
    end
    [~,idx]=sort(z,'descend');
    for kl=1:soil.N
        soil_mod.layer(kl).name=soil.layer(idx(kl)).name;
        soil_mod.layer(kl).z   =soil.layer(idx(kl)).z;
        soil_mod.layer(kl).mu  =soil.layer(idx(kl)).mu;
        soil_mod.layer(kl).nu  =soil.layer(idx(kl)).nu;
        soil_mod.layer(kl).rho =soil.layer(idx(kl)).rho;
        soil_mod.layer(kl).xi  =soil.layer(idx(kl)).xi;
    end
    soil = soil_mod;
    handles.figure1.UserData = soil;
    
    listString=sprintf("%d (%s) at %g",1,soil.layer(1).name,soil.layer(1).z);
    for kl = 2:soil.N
        tmpstr=sprintf("|%d (%s) at %g",kl,soil.layer(kl).name,soil.layer(kl).z);
        listString=strcat(listString,tmpstr);
    end
    handles.listboxLayers.String=listString;
    handles.listboxLayers.Value=find(idx==active);



    
    




% --- Executes during object creation, after setting all properties.
function editz_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editz (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbuttonRemove.
function pushbuttonRemove_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonRemove (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
active = handles.listboxLayers.Value;
soil = handles.figure1.UserData;
if soil.N>1
    soil_mod = soil;
    kln=1;
    for kl=1:soil.N
        if kl~=active
            soil_mod.layer(kln)=soil.layer(kl);
            kln=kln+1;
        end
    end
    soil_mod.N = soil.N-1;
    soil_mod.layer = soil_mod.layer(1:soil_mod.N);
    soil = soil_mod;
    if active>1
        handles.listboxLayers.Value=active-1;
        active=active-1;
    else
        soil.layer(1).z=0;
    end
    handles.editN.String=sprintf('%g',soil.N);
    handles.editname.String=sprintf('%s',soil.layer(active).name);
    handles.editz.String   =sprintf('%g',soil.layer(active).z);                      
    handles.editmu.String  =sprintf('%g',soil.layer(active).mu);
    handles.editnu.String  =sprintf('%g',soil.layer(active).nu);
    handles.editrho.String =sprintf('%g',soil.layer(active).rho);
    handles.editxi.String  =sprintf('%g',soil.layer(active).xi);
    handles.editname.BackgroundColor=get(0,'defaultUicontrolBackgroundColor');
    handles.editz.BackgroundColor   =get(0,'defaultUicontrolBackgroundColor');                  
    handles.editmu.BackgroundColor  =get(0,'defaultUicontrolBackgroundColor');
    handles.editnu.BackgroundColor  =get(0,'defaultUicontrolBackgroundColor');
    handles.editrho.BackgroundColor =get(0,'defaultUicontrolBackgroundColor');
    handles.editxi.BackgroundColor  =get(0,'defaultUicontrolBackgroundColor');
    if active==1
        handles.editz.Enable='off';
    else
        handles.editz.Enable='on';
    end
    handles.figure1.UserData = soil;
    writeListLayers(handles);
    plotStratigraphy(handles);    
end
    



function editN_Callback(hObject, eventdata, handles)
% hObject    handle to editN (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editN as text
%        str2double(get(hObject,'String')) returns contents of editN as a double


% --- Executes during object creation, after setting all properties.
function editN_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editN (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function editname_Callback(hObject, eventdata, handles)
% hObject    handle to editname (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editname as text
%        str2double(get(hObject,'String')) returns contents of editname as a double
active = handles.listboxLayers.Value;
handles.figure1.UserData.layer(active).name = get(hObject,'String');
writeListLayers(handles);
plotStratigraphy(handles);

% --- Executes during object creation, after setting all properties.
function editname_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editname (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes when user attempts to close figure1.
function figure1_CloseRequestFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: delete(hObject) closes the figure
if isequal(get(hObject, 'waitstatus'), 'waiting')
    % The GUI is still in UIWAIT, us UIRESUME
    uiresume(hObject);
else
    % The GUI is no longer waiting, just close it
    delete(hObject);
end
