function [data,st] = ReadSoilStratigraphyFile(data,fS,execute_mode)

    %% Stratigraphy
    if exist(fS)~=2
        msg = 'SoilStratigraphy input file cannot be found';
        f_display_error(execute_mode,msg);
    end
    INP = fopen(fS,'r+');


    Soil.N = fscanf(INP,'%d',1);         % Number of strata

    name = cell(Soil.N,1); % Name of each stratum
    zdom = zeros(Soil.N,1); % Higher z coordinate of each stratum
    mus =  zeros(Soil.N,1); % Shear modulus of elasticity
    nus =  zeros(Soil.N,1); % Poisson’s ratio
    rhos = zeros(Soil.N,1); % Mass density
    xis =  zeros(Soil.N,1); % Damping ratio
    bedrock = zeros(Soil.N,1);

    for idstratum = 1:Soil.N
        name{idstratum} =    fscanf(INP,'%s',1);
        zdom(idstratum) =    fscanf(INP,'%f',1);
        bedrock(idstratum) = fscanf(INP,'%d',1);

        switch bedrock(idstratum)
            case 0
                mus(idstratum) =  fscanf(INP,'%f',1);
                nus(idstratum) =  fscanf(INP,'%f',1);
                rhos(idstratum) = fscanf(INP,'%f',1);
                xis(idstratum) =  fscanf(INP,'%f',1);
            case 1
                % nothing
            otherwise
                msg = 'Incorrect bedrock option';
                f_display_error(execute_mode,msg);
        end
    end

    if isempty(Soil.N) || isempty(name) || isempty(mus) || isempty(nus) || ...
         isempty(rhos) || isempty(xis) || isempty(zdom)
        msg = 'Soil input incomplete';
        f_display_error(execute_mode,msg);
    end
    if ( (length(mus)~=Soil.N) || (length(rhos)~=Soil.N) || (length(nus)~=Soil.N) || ...
         (length(xis)~=Soil.N) || (length(zdom)~=Soil.N)                             )
        msg = 'Soil properties are not defined properly';
        f_display_error(execute_mode,msg);
    end

    zdom = (-1)*abs(zdom);

    % missing function: check order strata and properties

    switch max(bedrock)
        case 1
            Soil.bedrock = true;
        case 0
            Soil.bedrock = false;
    end

    for iddom = 1:Soil.N
        if iddom~=Soil.N || (iddom==Soil.N && ~Soil.bedrock)
            Soil.layer(iddom).mu =  mus(iddom);
            Soil.layer(iddom).rho = rhos(iddom);
            Soil.layer(iddom).nu =  nus(iddom);
            Soil.layer(iddom).xi =  xis(iddom);
            Soil.layer(iddom).cs =  sqrt(mus(iddom)/rhos(iddom));
        else
            Soil.layer(iddom).cs = Inf;
        end
        Soil.layer(iddom).name = name{iddom};
        Soil.layer(iddom).z =    zdom(iddom);
    end
    data.Soil = Soil;

    st = fclose(INP);
end

function f_display_error(execute_mode,msg)
    switch execute_mode
        case 1 % GUI
            errordlg(msg, 'Alert', 'modal')
        case 2 % command 
            error(msg)
        otherwise
            error('Wrong execution mode selected.')
    end
    return
end
