function [data,st] = ReadMeshOptionsFile(data,fMO,execute_mode)

    %% Mesh Options
    if exist(fMO)==2
        % File does exist
        INP = fopen(fMO,'r+');

        tool =      fscanf(INP,'%d',1);
        ratio_r =   fscanf(INP,'%f',1);
        ratio_R =   fscanf(INP,'%f',1);
        ratio_D =   fscanf(INP,'%f',1);
        nepl_near = fscanf(INP,'%f',1);
        nepl_far =  fscanf(INP,'%f',1);
        nepd_pile = fscanf(INP,'%f',1);
        nelo_near = fscanf(INP,'%f',1);
        nelo_far =  fscanf(INP,'%f',1);
        nelo_pile = fscanf(INP,'%f',1);
        t =         fscanf(INP,'%f',1);
        tolerance = fscanf(INP,'%f',1);

        st = fclose(INP);

        if isempty(ratio_R)    || isempty(ratio_r)   || ...
            isempty(ratio_D)   || isempty(tool)      || ...
            isempty(nepl_near) || isempty(nelo_near) || ...
            isempty(nepl_far)  || isempty(nelo_far)  || ...
            isempty(nepd_pile) || isempty(nelo_pile) || ...
            isempty(tolerance) || isempty(t)

            msg = 'Mesh options input incomplete';
            f_display_error(execute_mode,msg);
        end

        switch tool
            case 1;     toolpath = strcat(pwd,'/mesh2d/');
            case 2;     toolpath = 'gmsh';
        end

        Mopt = struct('tool',tool,'toolpath', toolpath,'t',t,     ...
                      'tolerance',tolerance,'ratio_R',  ratio_R,  ...
                      'ratio_r',  ratio_r,  'ratio_D',  ratio_D,  ...
                      'nepl_near',nepl_near,'nelo_near',nelo_near,...
                      'nepl_far', nepl_far, 'nelo_far', nelo_far, ...
                      'nepd_pile',nepd_pile,'nelo_pile',nelo_pile); 
    else
        % File does not exist
        Mopt = struct('tool',1,'toolpath',strcat(pwd,'/mesh2d/'),    ...
                      'ratio_r',1.5,'ratio_D',3,'ratio_R',3,         ...
                      'nepl_near',1,'nelo_near',6,'nepl_far',4,      ...
                      'nelo_far',2,'nepd_pile',1,'nelo_pile',2,'t',0,...
                      'tolerance',1.e-6); 
    end

    data.MeshOptions = Mopt;
end
