function [data,st] = ReadFrequenciesFile(data,fW,execute_mode)

    %% Frequencies
    if exist(fW)~=2
        msg = 'Frequencies input file cannot be found';
        f_display_error(execute_mode,msg);
    end
    INP = fopen(fW,'r+');

    W.type = fscanf(INP,'%d',1);
    nfreq =  fscanf(INP,'%d',1);

    W.value = zeros(nfreq,1);
    for idfreq = 1:nfreq
        W.value(idfreq) = fscanf(INP,'%f',1); % Vector of values
    end
    
    W.ref = fscanf(INP,'%d',1); % 1) D,c , 2) w_ref, 3) f_ref
    if W.ref~=1 && W.ref~=2 && W.ref~=3
        msg = 'Incorrect frequencie reference type';
        f_display_error(execute_mode,msg);
    end
    switch W.ref
        case 1
            W.ref_data(1) = fscanf(INP,'%f',1);
            W.ref_data(2) = fscanf(INP,'%f',1);
        case {2,3}
            W.ref_data = fscanf(INP,'%f',1);
    end

    st = fclose(INP);

    if isempty(W.type) || isempty(W.value) || isempty(W.ref) || isempty(W.ref_data)
        msg = 'Frequencie input incomplete';
        f_display_error(execute_mode,msg);
    end
    if W.type~=1 && W.type~=2 && W.type~=3
        msg = 'Incorrect frequencie type';
        f_display_error(execute_mode,msg);
    end
    if (W.ref==1 && length(W.ref_data)~=2) || (W.ref==2 && length(W.ref_data)~=1)
        msg = 'Incorrect frequencie reference value(s)';
        f_display_error(execute_mode,msg);
    end

    data.Frequencies = W;
end

function f_display_error(execute_mode,msg)
    switch execute_mode
        case 1 % GUI
            errordlg(msg, 'Alert', 'modal')
        case 2 % command 
            error(msg)
        otherwise
            error('Wrong execution mode selected.')
    end
    return
end
