function PlotMesh(handle,nx,en,enn,ed,draw_nodes)
    % handle: handle to axes. Optional.
    % nx(node_id,coordinate): node coordinates
    % en(elem_id,node_index): element nodes (classical FEM order)
    % enn(elem_id): number of nodes of the element (2 (linear line), 
    %               3 (quadratic line or linear tri.),
    %               4 (bilinear quad.), 6 (quadratic tri.), 
    %               8 (serendipity quad.), 9 (biquadratic quad.)). Optional.
    %               Column vector.
    % ed(elem_id): dimension of the element (1 (line element), 
    %              2 (surface element), 3 (volume element)) (not yet).
    %              Column vector.
    % All elements are drawn as linear elements.
    %
    if isempty(handle)
        figure;
        hnd = gca;
    else
        hnd = handle;
    end
    hold(hnd,'on')
    dim = length(nx(1,:));
    switch dim
        case 2
            elem = intersect([find(enn==2);find(enn==3)],find(ed==1));
            elem = reshape(elem,1,length(elem));
            for ke = elem
                line(hnd,nx(en(ke,1:2),1),nx(en(ke,1:2),2),'Color','red')
            end
            elem = intersect([find(enn==3);find(enn==6)],find(ed==2));
            elem = reshape(elem,1,length(elem));
            for ke = elem
                patch(hnd,nx(en(ke,1:3),1),nx(en(ke,1:3),2),'white')
            end
            elem = intersect([find(enn==4);find(enn==8),find(enn==9)],find(ed==2));
            elem = reshape(elem,1,length(elem));
            for ke = elem
                patch(hnd,nx(en(ke,1:4),1),nx(en(ke,1:4),2),'white')
            end
        case 3
            elem = intersect([find(enn==2);find(enn==3)],find(ed==1));
            elem = reshape(elem,1,length(elem));
            for ke = elem
                line(hnd,nx(en(ke,1:2),1),nx(en(ke,1:2),2),nx(en(ke,1:2),3),'Color','red')
            end
            elem = intersect([find(enn==3);find(enn==6)],find(ed==2));
            elem = reshape(elem,1,length(elem));
            for ke = elem
                patch(hnd,nx(en(ke,1:3),1),nx(en(ke,1:3),2),nx(en(ke,1:3),3),'white')
            end
            elem = intersect([find(enn==4);find(enn==8),find(enn==9)],find(ed==2));
            elem = reshape(elem,1,length(elem));
            for ke = elem
                patch(hnd,nx(en(ke,1:4),1),nx(en(ke,1:4),2),nx(en(ke,1:4),3),'white')
            end
        otherwise
            error('Invalid node coordinates matrix (nx)')
    end
    if draw_nodes
        switch dim
            case 2
                plot(nx(:,1),nx(:,2),'ko','MarkerSize',2)
            case 3
                plot3(nx(:,1),nx(:,2),nx(:,3),'ko','MarkerSize',2)
        end
    end
    view(dim)
    set(hnd,'Box','on')
    set(hnd,'DataAspectRatio',[1 1 1])
    set(hnd,'Box','on')
    xlabel(hnd,'x')
    ylabel(hnd,'y')
    if length(nx(1,:))==3
        zlabel(hnd,'z')
    end
end
