function varargout = MeshOptions(varargin)
% MESHOPTIONS MATLAB code for MeshOptions.fig
%      MESHOPTIONS, by itself, creates a new MESHOPTIONS or raises the existing
%      singleton*.
%
%      H = MESHOPTIONS returns the handle to a new MESHOPTIONS or the handle to
%      the existing singleton*.
%
%      MESHOPTIONS('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in MESHOPTIONS.M with the given input arguments.
%
%      MESHOPTIONS('Property','Value',...) creates a new MESHOPTIONS or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before MeshOptions_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to MeshOptions_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help MeshOptions

% Last Modified by GUIDE v2.5 02-Nov-2017 15:45:37

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @MeshOptions_OpeningFcn, ...
                   'gui_OutputFcn',  @MeshOptions_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before MeshOptions is made visible.
function MeshOptions_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to MeshOptions (see VARARGIN)

if length(varargin)==1 && ~isempty(varargin{1})
    meshopt=varargin{1};
    handles.pushbuttonCancel.UserData=meshopt;
else
    handles.figure1.UserData=[];
    [path,filename,extension] = fileparts(mfilename('fullpath'));
    % Default values
    meshopt=struct('tool',1,...       % Mesh generator: 1) MESH2D (default), 2) Gmsh
                   'toolpath',fullfile(path,'mesh2d'),...  
                   'ratio_r',1.5,...
                   'ratio_D',3,...
                   'ratio_R',3,...
                   'nepl_near',1,...                   
                   'nelo_near',6,...
                   'nepl_far',4,...                   
                   'nelo_far',2,...
                   'nepd_pile',1,...
                   'nelo_pile',2,...
                   't',0,...             % parameter for pile mesh (0<=t<=1)
                   'tolerance',1.e-6);            
     handles.pushbuttonCancel.UserData=meshopt;
end

handles.popupmenutool.Value = meshopt.tool;
handles.textPath.String = meshopt.toolpath;
handles.editratio_r.String = sprintf('%g',meshopt.ratio_r);
handles.editratio_D.String = sprintf('%g',meshopt.ratio_D);
handles.editratio_R.String = sprintf('%g',meshopt.ratio_R);
handles.editnepl_near.String = sprintf('%g',meshopt.nepl_near);
handles.editnelo_near.String = sprintf('%g',meshopt.nelo_near);
handles.editnepl_far.String = sprintf('%g',meshopt.nepl_far);
handles.editnelo_far.String = sprintf('%g',meshopt.nelo_far);
handles.editnepd_pile.String = sprintf('%g',meshopt.nepd_pile);
handles.editnelo_pile.String = sprintf('%g',meshopt.nelo_pile);
handles.slidert.Value = meshopt.t;
handles.editTol.String = sprintf('%g',meshopt.tolerance);

handles.pushbuttonAccept.UserData = 0;

% Choose default command line output for MeshOptions
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);
movegui(hObject,'center');

% UIWAIT makes MeshOptions wait for user response (see UIRESUME)
uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = MeshOptions_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
% if round(handles.pushbuttonAccept.UserData)==1
%     freq=handles.figure1.UserData;
% else
%     freq=handles.pushbuttonCancel.UserData;
% end
if round(handles.pushbuttonAccept.UserData)==1
    meshopt=struct('tool',1,...       % Mesh generator: 1) mesh2d, 2) gmsh
                   'toolpath',strcat(pwd,'/mesh2d/'),...  
                   'ratio_r',1.5,...
                   'ratio_D',3,...
                   'ratio_R',3,...
                   'nepl_near',1,...                   
                   'nelo_near',6,...
                   'nepl_far',4,...                   
                   'nelo_far',2,...
                   'nepd_pile',3,...
                   'nelo_pile',1,...
                   't',0,...           % parameter for pile mesh (0<=t<=1)
                   'tolerance',1.e-6);           
    meshopt.tool=handles.popupmenutool.Value;
    meshopt.toolpath=handles.textPath.String;
    meshopt.ratio_r=str2double(handles.editratio_r.String);
    meshopt.ratio_D=str2double(handles.editratio_D.String);
    meshopt.ratio_R=str2double(handles.editratio_R.String);
    meshopt.nepl_near=str2double(handles.editnepl_near.String);
    meshopt.nelo_near=str2double(handles.editnelo_near.String);
    meshopt.nepl_far=str2double(handles.editnepl_far.String);
    meshopt.nelo_far=str2double(handles.editnelo_far.String);
    meshopt.nepd_pile=str2double(handles.editnepd_pile.String);
    meshopt.nelo_pile=str2double(handles.editnelo_pile.String);
    meshopt.t=handles.slidert.Value;
    meshopt.tolerance=handles.editTol.Value;
else
    meshopt=handles.pushbuttonCancel.UserData;
end
varargout{1} = meshopt;
delete(handles.figure1);


% --- Executes when user attempts to close figure1.
function figure1_CloseRequestFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: delete(hObject) closes the figure
if isequal(get(hObject, 'waitstatus'), 'waiting')
    % The GUI is still in UIWAIT, us UIRESUME
    uiresume(hObject);
else
    % The GUI is no longer waiting, just close it
    delete(hObject);
end





function editratio_r_Callback(hObject, eventdata, handles)
% hObject    handle to editratio_r (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editratio_r as text
%        str2double(get(hObject,'String')) returns contents of editratio_r as a double


% --- Executes during object creation, after setting all properties.
function editratio_r_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editratio_r (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end





% --- Executes on selection change in popupmenutool.
function popupmenutool_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenutool (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns popupmenutool contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenutool
switch hObject.Value
    case 1
        [path,filename,extension] = fileparts(mfilename('fullpath'));
        handles.textPath.String=fullfile(path,'mesh2d');
    case 2
        handles.textPath.String='gmsh';
end




% --- Executes during object creation, after setting all properties.
function popupmenutool_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenutool (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end







function editnelo_far_Callback(hObject, eventdata, handles)
% hObject    handle to editnelo_far (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editnelo_far as text
%        str2double(get(hObject,'String')) returns contents of editnelo_far as a double


% --- Executes during object creation, after setting all properties.
function editnelo_far_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editnelo_far (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function editnelo_near_Callback(hObject, eventdata, handles)
% hObject    handle to editnelo_near (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editnelo_near as text
%        str2double(get(hObject,'String')) returns contents of editnelo_near as a double


% --- Executes during object creation, after setting all properties.
function editnelo_near_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editnelo_near (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



% --- Executes on button press in pushbuttontoolpath.
function pushbuttontoolpath_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttontoolpath (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
switch handles.popupmenutool.Value
    case 1
        pathname = uigetdir('','Select MESH2D folder');
        if pathname == 0
            handles.textPath.String = '';
        else
            handles.textPath.String = pathname;
        end
        
    case 2
        [filename,pathname] = uigetfile({'*.*','All Files (*.*)'},'Select gmsh executable');
        if filename == 0
            handles.textPath.String = '';
        else
            handles.textPath.String = strcat(pathname,filename);
        end
end

% --- Executes on slider movement.
function slidert_Callback(hObject, eventdata, handles)
% hObject    handle to slidert (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider



% --- Executes during object creation, after setting all properties.
function slidert_CreateFcn(hObject, eventdata, handles)
% hObject    handle to slidert (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end




function editnepd_pile_Callback(hObject, eventdata, handles)
% hObject    handle to editnepd_pile (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editnepd_pile as text
%        str2double(get(hObject,'String')) returns contents of editnepd_pile as a double


% --- Executes during object creation, after setting all properties.
function editnepd_pile_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editnepd_pile (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end





function editratio_R_Callback(hObject, eventdata, handles)
% hObject    handle to editratio_R (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editratio_R as text
%        str2double(get(hObject,'String')) returns contents of editratio_R as a double


% --- Executes during object creation, after setting all properties.
function editratio_R_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editratio_R (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function editratio_D_Callback(hObject, eventdata, handles)
% hObject    handle to editratio_D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editratio_D as text
%        str2double(get(hObject,'String')) returns contents of editratio_D as a double


% --- Executes during object creation, after setting all properties.
function editratio_D_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editratio_D (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbuttonAccept.
function pushbuttonAccept_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonAccept (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
hObject.UserData = 1;
figure1_CloseRequestFcn(handles.figure1, eventdata, handles);

% --- Executes on button press in pushbuttonCancel.
function pushbuttonCancel_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonCancel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
figure1_CloseRequestFcn(handles.figure1, eventdata, handles);



function editnepl_near_Callback(hObject, eventdata, handles)
% hObject    handle to editnepl_near (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editnepl_near as text
%        str2double(get(hObject,'String')) returns contents of editnepl_near as a double


% --- Executes during object creation, after setting all properties.
function editnepl_near_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editnepl_near (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function editnepl_far_Callback(hObject, eventdata, handles)
% hObject    handle to editnepl_far (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editnepl_far as text
%        str2double(get(hObject,'String')) returns contents of editnepl_far as a double


% --- Executes during object creation, after setting all properties.
function editnepl_far_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editnepl_far (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function editnelo_pile_Callback(hObject, eventdata, handles)
% hObject    handle to editnelo_pile (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editnelo_pile as text
%        str2double(get(hObject,'String')) returns contents of editnelo_pile as a double


% --- Executes during object creation, after setting all properties.
function editnelo_pile_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editnelo_pile (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function editTol_Callback(hObject, eventdata, handles)
% hObject    handle to editTol (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editTol as text
%        str2double(get(hObject,'String')) returns contents of editTol as a double


% --- Executes during object creation, after setting all properties.
function editTol_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editTol (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
