function varargout = Main(varargin)
% MAIN MATLAB code for Main.fig
%      MAIN, by itself, creates a new MAIN or raises the existing
%      singleton*.
%
%      H = MAIN returns the handle to a new MAIN or the handle to
%      the existing singleton*.
%
%      MAIN('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in MAIN.M with the given input arguments.
%
%      MAIN('Property','Value',...) creates a new MAIN or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before Main_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to Main_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help Main

% Last Modified by GUIDE v2.5 15-Dec-2017 14:11:36

% Begin initialization code - DO NOT EDIT

gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @Main_OpeningFcn, ...
                   'gui_OutputFcn',  @Main_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT

% --- Executes just before Main is made visible.
function Main_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to Main (see VARARGIN)

if length(varargin)==1 && ~isempty(varargin{1})
    data = varargin{1};
else
    data = struct('Name','noname',...
              'Path',pwd,...
              'Soil',[],...
              'PileGroupType',[],...
              'PileGroup',[],...
              'Frequencies',[],...
              'MeshOptions',[],...
              'Mesh',[],...
              'Analysis',struct('Impedances',zeros(1,6)));
end
if isempty(data.MeshOptions)
    [path,filename,extension] = fileparts(mfilename('fullpath'));
    data.MeshOptions = struct('tool',1,'toolpath',fullfile(path,'mesh2d'),...
                          'ratio_r',1.5,'ratio_D',3,'ratio_R',3,         ...
                          'nepl_near',1,'nelo_near',6,'nepl_far',4,      ...
                          'nelo_far',2,'nepd_pile',1,'nelo_pile',2,'t',0,...
                          'tolerance',1.e-6); 
end
InitGUI(data,handles);

                              
% Choose default command line output for Main
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);
movegui(hObject,'center');

% UIWAIT makes Main wait for user response (see UIRESUME)
uiwait(handles.figure1);

function InitGUI(data,handles)
% Save data structure
handles.figure1.UserData = data;
% Initialize Project name and path
handles.editProjectName.String = data.Name;
handles.textProjectPath.String = data.Path;
% Initialize impedances checkboxes
handles.checkboxLateralx.Value  = data.Analysis.Impedances(1);
handles.checkboxLateraly.Value  = data.Analysis.Impedances(2);
handles.checkboxVerticalz.Value = data.Analysis.Impedances(3);
handles.checkboxRockingrx.Value = data.Analysis.Impedances(4);
handles.checkboxRockingry.Value = data.Analysis.Impedances(5);
% Calculate approximate required RAM memory
if ~isempty(data.Mesh)
    mesh = data.Mesh;
    memRAM = CalculateRAM(mesh.sn(:,3),length(mesh.pn(:,1)));
    str = sprintf('Approximate required memory is %g GB',memRAM);
    fprintf('%s ...\n',str);
    handles.textRAM.String = str;
    handles.textRAM.BackgroundColor = [1 0.5 0];
end

% --- Outputs from this function are returned to the command line.
function varargout = Main_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
varargout{1} = handles.figure1.UserData;
delete(handles.figure1);

%_________________________________________________________________________%
%_________________________________________________________________________%

% PROJECT NAME

% --- Executes during object creation, after setting all properties.
function editProjectName_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editProjectName (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function editProjectName_Callback(hObject, eventdata, handles)
% hObject    handle to editProjectName (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editProjectName as text
%        str2double(get(hObject,'String')) returns contents of editProjectName as a double
handles.figure1.UserData.Name = handles.editProjectName.String;

% --- Executes on button press in pushbuttonProjectPath.
function pushbuttonProjectPath_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonProjectPath (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles.textProjectPath.String = uigetdir();
handles.figure1.UserData.Path = handles.textProjectPath.String;


%_________________________________________________________________________%

% MENU File: New, Load, Save, Preferences, quit

function MenuFile_Callback(hObject, eventdata, handles)
% hObject    handle to MenuFile (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


function MenuNew_Callback(hObject, eventdata, handles)
% hObject    handle to MenuNew (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
data = struct('Name','noname',...
              'Path','.',...
              'Soil',[],...
              'PileGroupType',[],...
              'PileGroup',[],...
              'Frequencies',[],...
              'MeshOptions',[],...
              'Mesh',[],...
              'Analysis',struct('Impedances',zeros(1,6)));
data.MeshOptions = struct('tool',1,'toolpath',strcat(pwd,'/mesh2d/'),...
                      'ratio_r',1.5,'ratio_D',3,'ratio_R',3,         ...
                      'nepl_near',1,'nelo_near',6,'nepl_far',4,      ...
                      'nelo_far',2,'nepd_pile',1,'nelo_pile',2,'t',0,...
                      'tolerance',1.e-6); 
InitGUI(data,handles);


function MenuOpen_Callback(hObject, eventdata, handles)
% hObject    handle to MenuOpen (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
data = handles.figure1.UserData;
filterspec = {'*.mat','Binary file with all data (*.mat)';
    '*.soi','Plain text file with soil stratigraphy (*.soi)';
    '*.pil','Plain text file with pile configuration (*.pil)';
    '*.fre','Plain text file with frequencies (*.fre)';
    '*.mop','Plain text file with mesh options (*.mop)';
    '*.mes','Plain text file with mesh in native format (*.mes)'};
[filename,path,filteridx] = uigetfile(filterspec,'Load file',fullfile(data.Path));
if ~(isequal(filename,0) || isequal(path,0) || filteridx==0)
    switch filteridx
        case 1
            load(fullfile(path,filename),'-struct','data');
        case 2
            [data,st] = ReadSoilStratigraphyFile(data,fullfile(path,filename),1);
            if st~=0
                errordlg('Some problem occurred when reading soil stratigraphy file.', 'Error', 'modal');
            end
        case 3
            [data,st] = ReadPileConfigurationFile(data,fullfile(path,filename),1);
            if st~=0
                errordlg('Some problem occurred when reading pile configuration file.', 'Error', 'modal');
            end
        case 4
            [data,st] = ReadFrequenciesFile(data,fullfile(path,filename),1);
            if st~=0
                errordlg('Some problem occurred when reading frequencies file.', 'Error', 'modal');
            end
        case 5
            [data,st] = ReadMeshOptionsFile(data,fullfile(path,filename),1);
            if st~=0
                errordlg('Some problem occurred when reading mesh options file.', 'Error', 'modal');
            end
        case 6
            [data,st] = msh_UserMesh(data,1,fullfile(path,filename));
            if st~=0
                errordlg('Some problem occurred when reading mesh file.', 'Error', 'modal');
            end
            data = msh_piles(data,1);
    end
end
handles.figure1.UserData = data;


function MenuSave_Callback(hObject, eventdata, handles)
% hObject    handle to MenuSave (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
data = handles.figure1.UserData;
filterspec = {'*.mat','Binary file with all data (*.mat)';
    '*.soi','Plain text file with soil stratigraphy (*.soi)';
    '*.pil','Plain text file with pile configuration (*.pil)';
    '*.fre','Plain text file with frequencies (*.fre)';
    '*.mop','Plain text file with mesh options (*.mop)';
    '*.mes','Plain text file with mesh in native format (*.mes)'};
defaultfile = strcat(data.Path,data.Name,'.mat');
[filename,path,filteridx] = uiputfile(filterspec,'Save as',defaultfile);
path = './destino';
if ~(isequal(filename,0) || isequal(path,0) || filteridx==0)
    switch filteridx
        case 1
            save(fullfile(path,filename),'-struct','data');
        case 2
            if isempty(data.Soil)
                errordlg('Soil stratigraphy is undefined.', 'Error', 'modal');
            else
                st = WriteSoilStratigraphyFile(data.Soil,fullfile(path,filename));
                if st~=0
                    errordlg('Some problem occurred when creating soil stratigraphy file.', 'Error', 'modal');
                end
            end
        case 3
            if isempty(data.PileGroupType)
                errordlg('Pile configuration is undefined.', 'Error', 'modal');
            else
                st = WritePileConfigurationFile(data.PileGroupType,fullfile(path,filename));
                if st~=0
                    errordlg('Some problem occurred when creating pile configuration file.', 'Error', 'modal');
                end
            end
        case 4
            if isempty(data.Frequencies)
                errordlg('Frequencies are undefined.', 'Error', 'modal');
            else
                st = WriteFrequenciesFile(data.Frequencies,fullfile(path,filename));
                if st~=0
                    errordlg('Some problem occurred when creating frequencies file.', 'Error', 'modal');
                end
            end  
        case 5
            if isempty(data.MeshOptions)
                errordlg('Mesh options are undefined.', 'Error', 'modal');
            else
                st = WriteMeshOptionsFile(data.MeshOptions,fullfile(path,filename));
                if st~=0
                    errordlg('Some problem occurred when creating mesh options file.', 'Error', 'modal');
                end
            end  
        case 6
            if isempty(data.Mesh)
                errordlg('Mesh is undefined.', 'Error', 'modal');
            else
                WriteMeshFile(data,fullfile(path,filename));
            end
    end
end


function MenuQuit_Callback(hObject, eventdata, handles)
% hObject    handle to MenuQuit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
ButtonName = questdlg('Do you really want to quit?','Quit','Cancel', 'Accept','Cancel');
if ButtonName == 'Accept'
    figure1_CloseRequestFcn(handles.figure1, eventdata, handles);
end

%_________________________________________________________________________%

% SOIL STRATIGRAPHY DATA

% --- Executes on button press in pushbuttonSoilStratigraphy.
function pushbuttonSoilStratigraphy_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonSoilStratigraphy (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles.figure1.UserData.Soil = SoilStratigraphy(handles.figure1.UserData.Soil);


%_________________________________________________________________________%

% CONFIGURATION DATA

% --- Executes during object creation, after setting all properties.
function popupmenuConfiguration_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenuConfiguration (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on selection change in popupmenuConfiguration.
function popupmenuConfiguration_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenuConfiguration (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns popupmenuConfiguration contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenuConfiguration
c=hObject.Value;
switch c
    case {1,2}
        handles.figure1.UserData.PileGroupType = [];
        handles.figure1.UserData.PileGroup = [];
    otherwise
        hObject.Value = 1;
        errordlg('Not implemented yet', 'Alert', 'modal');
end

% --- Executes on button press in pushbuttonConfiguration.
function pushbuttonConfiguration_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonConfiguration (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
c=handles.popupmenuConfiguration.Value;
switch c
    case 1
        handles.figure1.UserData.PileGroupType = Configuration(handles.figure1.UserData.PileGroupType);
        % Save to local variable
        P = handles.figure1.UserData.PileGroupType;
        % Translation to general discretization structure of the pile group
        PilesHeadX=P.PileHeadX;
        PilesTipX=P.PileTipX;
        NPiles = 0;
        for kp=1:P.Nx*P.Ny
            xh = P.PileHeadX(kp,:);
            xt = P.PileTipX(kp,:);
            if xh(1)>=0 && xh(2)>=0
                NPiles = NPiles+1;
                PilesHeadX(NPiles,:)=xh;
                PilesTipX(NPiles,:)=xt;
            end
        end
        % Generate general data structure
        pile = struct('xhead',[],...
                      'xtip',[],...
                      'Do',[],...
                      'Di',[],...
                      'A',[],...
                      'I',[],...
                      'E',[],...
                      'rho',[]);
        PileGroup=struct('Symmetry',4,... % Symmetry: 1 (no symmetry), 2 (half-symmetry), 4 (quarter-symmetry)
                         'N',NPiles,...   % Number of piles in the discretization 
                         'Pile',pile);
        PileGroup.Pile(NPiles) = pile; 
        for kp=1:NPiles
            PileGroup.Pile(kp).xhead = PilesHeadX(kp,:);
            PileGroup.Pile(kp).xtip  = PilesTipX(kp,:);
            PileGroup.Pile(kp).Do    = P.Do;
            PileGroup.Pile(kp).Di    = P.Di;
            PileGroup.Pile(kp).A     = pi*((P.Do)^2-(P.Di)^2)/4;
            PileGroup.Pile(kp).I     = pi*((P.Do)^4-(P.Di)^4)/64;
            PileGroup.Pile(kp).E     = P.E;
            PileGroup.Pile(kp).rho   = P.rho;
        end
        handles.figure1.UserData.PileGroup = PileGroup;
%    case 2

    otherwise
        hObject.Value = 1;
        errordlg('Not implemented yet', 'Alert', 'modal');
end


%_________________________________________________________________________%

% FREQUENCY

% --- Executes on button press in pushbuttonFrequencies.
function pushbuttonFrequencies_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonFrequencies (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)      
freq = handles.figure1.UserData.Frequencies;
% Load additional options for popupmenus
conf = handles.figure1.UserData.PileGroup;
soil = handles.figure1.UserData.Soil;
defaultopt = struct('name','Custom','value',1,'editable',true);
predefopt=struct('D',defaultopt,'c',defaultopt,'w_ref',defaultopt,'f_ref',defaultopt);
if ~isempty(conf)
    for k=1:conf.N
        opt = struct('name',sprintf('Pile %d - Diameter',k),'value',conf.Pile(k).Do,'editable',false);
        predefopt.D(k) = opt;
    end
else
    predefopt.D = [];
end
if ~isempty(soil)
    for k=1:soil.N
        opt = struct('name',sprintf('Layer %d - cs',k),'value',soil.layer(k).cs,'editable',false);
        predefopt.c(k) = opt;
    end
else
    predefopt.c = [];
end
handles.figure1.UserData.Frequencies = Frequencies(freq,predefopt);


%_________________________________________________________________________%
%_________________________________________________________________________%

% MESH OPTIONS

% --- Executes on button press in pushbuttonMeshOptions.
function pushbuttonMeshOptions_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonMeshOptions (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles.figure1.UserData.MeshOptions = MeshOptions(handles.figure1.UserData.MeshOptions);

%_________________________________________________________________________%

% BUTTON GENERATE MESH

% --- Executes on button press in pushbuttonMeshGenerate.
function pushbuttonMeshGenerate_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonMeshGenerate (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% Generate mesh
handles.figure1.UserData.Mesh = [];
data = handles.figure1.UserData;
% Check requirements
ch = true;
str = '';
if isempty(data.Soil)
    ch = false;
    str = strcat(str,'<Soil>');
end
if isempty(data.PileGroup)
    ch = false;
    str = strcat(str,'<Pile group>');
end
if isempty(data.Frequencies)
    ch = false;
    str = strcat(str,'<Frequencies>');
end
% Generate mesh
if ch
    switch data.MeshOptions.tool
        case 1
            data = msh_MESH2D(data);
        case 2
            data = msh_Gmsh_S4(data);
        otherwise
            error('Invalid meshing tool')
    end
    data = msh_piles(data);
    % Check mesh
    data = CheckMesh(data);
    % Save mesh
    handles.figure1.UserData = data;
    % Calculate approximate required RAM memory
    mesh = data.Mesh;
    memRAM = CalculateRAM(mesh.sn(:,3),length(mesh.pn(:,1)));
    str = sprintf('Approximate required memory is %g GB',memRAM);
    fprintf('%s ...\n',str);
    handles.textRAM.String = str;
    handles.textRAM.BackgroundColor = [1 0.5 0];
else
    errordlg(sprintf('Not defined yet: %s.',str), 'Mesh generation', 'modal');
end

%_________________________________________________________________________%

% LOAD MESH

% --- Executes on button press in pushbuttonLoadMesh.
function pushbuttonLoadMesh_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonLoadMesh (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
data = handles.figure1.UserData;
% Check requirements
ch = true;
str = '';
if isempty(data.Soil)
    ch = false;
    str = strcat(str,'<Soil>');
end
if isempty(data.PileGroup)
    ch = false;
    str = strcat(str,'<Pile group>');
end
if isempty(data.Frequencies)
    ch = false;
    str = strcat(str,'<Frequencies>');
end
% Generate mesh
if ch
    filterspec = {'*.mes','Plain text file with mesh in native format (*.mes)'};
    [filename,path] = uigetfile(filterspec,'Load mesh');
    if ~(isequal(filename,0) || isequal(path,0))
        data = msh_UserMesh(data,1,fullfile(path,filename));
        % Check mesh
        data = CheckMesh(data);
        % Save mesh
        handles.figure1.UserData = data;
        % Calculate approximate required RAM memory
        mesh = data.Mesh;
        memRAM = CalculateRAM(mesh.sn(:,3),length(mesh.pn(:,1)));
        str = sprintf('Approximate required memory is %g GB',memRAM);
        fprintf('%s ...\n',str);
        handles.textRAM.String = str;
        handles.textRAM.BackgroundColor = [1 0.5 0];
    end
else
    errordlg(sprintf('Not defined yet: %s.',str), 'Error when loading user mesh','modal');
end

%_________________________________________________________________________%

% VIEW MESH

% --- Executes on button press in pushbuttonViewMesh.
function pushbuttonViewMesh_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonViewMesh (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
data = handles.figure1.UserData;
if isempty(data.Mesh)
    errordlg('A mesh has not been generated yet.','Error','modal')
else
    % Calculate approximate required RAM memory
    mesh = data.Mesh;
    memRAM = CalculateRAM(mesh.sn(:,3),length(mesh.pn(:,1)));
    str = sprintf('Approximate required memory is %g GB',memRAM);
    fprintf('%s ...\n',str);
    handles.textRAM.String = str;
    handles.textRAM.BackgroundColor = [1 0.5 0];
    % Surface mesh
    nx  = data.Mesh.sn;
    en  = data.Mesh.se(:,4:12);
    enn = data.Mesh.se(:,2);
    ed  = data.Mesh.se(:,1);
    % Pile mesh
    nxp  = data.Mesh.pn;
    enp  = data.Mesh.pe(:,6:14);
    ennp = data.Mesh.pe(:,5);
    edp  = data.Mesh.pe(:,4);
    % Plot
    figure('Name',data.Name,'NumberTitle','off');
    ax = gca;
    PlotMesh(ax,[nx;nxp],[en;enp+length(nx(:,1))],[enn;ennp],[ed;edp],true);

end

%_________________________________________________________________________%

% HELP MESH

% --- Executes during object creation, after setting all properties.
function pushbuttonMeshHelp_CreateFcn(hObject, eventdata, handles)
% hObject    handle to pushbuttonMeshHelp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% --- Executes on button press in pushbuttonMeshHelp.
function pushbuttonMeshHelp_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonMeshHelp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if isunix || ismac
    open('MeshFormat.html');
elseif ispc
    open('MeshFormat_windows.html');
end

%_________________________________________________________________________%
%_________________________________________________________________________%

% HELP IMPEDANCES

% --- Executes on button press in pushbuttonImpedancesHelp.
function pushbuttonImpedancesHelp_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonImpedancesHelp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if isunix || ismac
    open('ImpedancesHelp.html')
elseif ispc
    open('ImpedancesHelp_windows.html')
end

%_________________________________________________________________________%

% CHECKBOXES FOR IMPEDANCES

% --- Executes on button press in checkboxLateralx.
function checkboxLateralx_Callback(hObject, eventdata, handles)
% hObject    handle to checkboxLateralx (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkboxLateralx
handles.figure1.UserData.Analysis.Impedances(1) = hObject.Value;

% --- Executes on button press in checkboxLateraly.
function checkboxLateraly_Callback(hObject, eventdata, handles)
% hObject    handle to checkboxLateraly (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkboxLateraly
handles.figure1.UserData.Analysis.Impedances(2) = hObject.Value;

% --- Executes on button press in checkboxVerticalz.
function checkboxVerticalz_Callback(hObject, eventdata, handles)
% hObject    handle to checkboxVerticalz (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkboxVerticalz
handles.figure1.UserData.Analysis.Impedances(3) = hObject.Value;

% --- Executes on button press in checkboxRockingrx.
function checkboxRockingrx_Callback(hObject, eventdata, handles)
% hObject    handle to checkboxRockingrx (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkboxRockingrx
handles.figure1.UserData.Analysis.Impedances(4) = hObject.Value;

% --- Executes on button press in checkboxRockingry.
function checkboxRockingry_Callback(hObject, eventdata, handles)
% hObject    handle to checkboxRockingry (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkboxRockingry
handles.figure1.UserData.Analysis.Impedances(5) = hObject.Value;


%_________________________________________________________________________%
%_________________________________________________________________________%

% GENERATE INPUT FILE

% --- Executes on button press in pushbuttonGenerateInputFiles.
function pushbuttonGenerateInputFiles_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonGenerateInputFiles (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
data = handles.figure1.UserData;
% Check requirements
ch = true;
str = '';
if isempty(data.Name)
    ch = false;
    str = strcat(str,'<Project Name>');
end
if isempty(data.Path)
    ch = false;
    str = strcat(str,'<Project Path>');
end
if isempty(data.Soil)
    ch = false;
    str = strcat(str,'<Soil>');
end
if isempty(data.PileGroup)
    ch = false;
    str = strcat(str,'<Pile group>');
end
if isempty(data.Frequencies)
    ch = false;
    str = strcat(str,'<Frequencies>');
end
if isempty(data.MeshOptions)
    ch = false;
    str = strcat(str,'<Mesh options>');
end
if isempty(data.Mesh)
    ch = false;
    str = strcat(str,'<Mesh>');
end
% Generate files
if ch
    st = ones(1,5);
    if data.Analysis.Impedances(1)>0
        filename = fullfile(data.Path,strcat(data.Name,'_x.dat'));
        st(1) = OUT_BEMFEMfile(filename,1,data);
    end
    if data.Analysis.Impedances(2)>0
        filename = fullfile(data.Path,strcat(data.Name,'_y.dat'));
        st(2) = OUT_BEMFEMfile(filename,2,data);
    end
    if data.Analysis.Impedances(3)>0
        filename = fullfile(data.Path,strcat(data.Name,'_z.dat'));
        st(3) = OUT_BEMFEMfile(filename,3,data);
    end
    if data.Analysis.Impedances(4)>0
        filename = fullfile(data.Path,strcat(data.Name,'_rx.dat'));
        st(4) = OUT_BEMFEMfile(filename,4,data);
    end
    if data.Analysis.Impedances(5)>0
        filename = fullfile(data.Path,strcat(data.Name,'_ry.dat'));
        st(5) = OUT_BEMFEMfile(filename,5,data);
    end
    % st returns 0 if successful or -1 if not
    if min(st) == 0
        uiwait(msgbox('File creation succeded.','Solver input files','modal'));
    end
    if min(st) == -1
        uiwait(msgbox('File creation failed.','Solver input files','modal'));
    end
else
    errordlg(sprintf('Not defined yet: %s.',str), 'Solver input files', 'modal');
end

%_________________________________________________________________________%

%  %  RUN  PROGRAM  %  %

% --- Executes during object creation, after setting all properties.
function RunProgram_CreateFcn(hObject, eventdata, handles)
% hObject    handle to RunProgram (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% --- Executes on button press in RunProgram.
function RunProgram_Callback(hObject, eventdata, handles)
% hObject    handle to RunProgram (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
data = handles.figure1.UserData;
% Check requirements
ch = true;
str = '';
if isempty(data.Name)
    ch = false;
    str = strcat(str,'<Project Name>');
end
if isempty(data.Path)
    ch = false;
    str = strcat(str,'<Project Path>');
end
if isempty(data.Soil)
    ch = false;
    str = strcat(str,'<Soil>');
end
if isempty(data.PileGroup)
    ch = false;
    str = strcat(str,'<Pile group>');
end
if isempty(data.Frequencies)
    ch = false;
    str = strcat(str,'<Frequencies>');
end
if isempty(data.MeshOptions)
    ch = false;
    str = strcat(str,'<Mesh options>');
end
if isempty(data.Mesh)
    ch = false;
    str = strcat(str,'<Mesh>');
end
% Generate files
if ch
    mesh = data.Mesh;
    memRAM = CalculateRAM(mesh.sn(:,3),length(mesh.pn(:,1)));
    str = sprintf('Approximate required memory is %g GB',memRAM);
    fprintf('%s ...\n',str);
    handles.textRAM.String = str;
    handles.textRAM.BackgroundColor = [1 0.5 0];
    str = sprintf('Approximate required memory is %g GB. Do you want to run the solver?',memRAM);
    ButtonName = questdlg(str,'Check system requirements','No');
    switch ButtonName
        case 'Yes'
        otherwise
            fprintf('User does not want to run the solver\n');
            return;
    end
    fprintf('User want to run the solver\n');
    if data.Analysis.Impedances(1)>0
        filename = fullfile(data.Path,strcat(data.Name,'_x.dat'));
        if ~exist(filename,'file')
            uiwait(msgbox('You have to first generate the input file','Run solver','modal'));
            return;
        end
        if isunix || ismac
            strcommand = sprintf('./piledyn_solver -f %s',filename);
        elseif ispc
            strcommand = sprintf('piledyn_solver.exe -f %s',filename);
        end 
        [status,~] = system(strcommand,'-echo');
        if status~=0
            disp(status)
            errordlg('Some error ocurred trying to run the solver','Run solver','modal')
        else
            msgbox(sprintf('Solver has ended running %s',filename),'Run solver','modal');
        end
    end
    if data.Analysis.Impedances(2)>0
        filename = fullfile(data.Path,strcat(data.Name,'_y.dat'));
        if ~exist(filename,'file')
            uiwait(msgbox('You have to first generate the input file','Run solver','modal'));
            return;
        end
        if isunix || ismac
            strcommand = sprintf('./piledyn_solver -f %s',filename);
        elseif ispc
            strcommand = sprintf('piledyn_solver.exe -f %s',filename);
        end 
        [status,~] = system(strcommand,'-echo');
        if status~=0
            disp(status)
            errordlg('Some error ocurred trying to run the solver','Run solver','modal')
        else
            msgbox(sprintf('Solver has ended running %s',filename),'Run solver','modal');
        end 
    end
    if data.Analysis.Impedances(3)>0
        filename = fullfile(data.Path,strcat(data.Name,'_z.dat'));
        if ~exist(filename,'file')
            uiwait(msgbox('You have to first generate the input file','Run solver','modal'));
            return;
        end
        if isunix || ismac
            strcommand = sprintf('./piledyn_solver -f %s',filename);
        elseif ispc
            strcommand = sprintf('piledyn_solver.exe -f %s',filename);
        end 
        [status,~] = system(strcommand,'-echo');
        if status~=0
            disp(status)
            errordlg('Some error ocurred trying to run the solver','Run solver','modal')
        else
            msgbox(sprintf('Solver has ended running %s',filename),'Run solver','modal');
        end
    end
    if data.Analysis.Impedances(4)>0
        filename = fullfile(data.Path,strcat(data.Name,'_rx.dat'));
        if ~exist(filename,'file')
            uiwait(msgbox('You have to first generate the input file','Run solver','modal'));
            return;
        end
        if isunix || ismac
            strcommand = sprintf('./piledyn_solver -f %s',filename);
        elseif ispc
            strcommand = sprintf('piledyn_solver.exe -f %s',filename);
        end 
        [status,~] = system(strcommand,'-echo');
        if status~=0
            disp(status)
            errordlg('Some error ocurred trying to run the solver','Run solver','modal')
        else
            msgbox(sprintf('Solver has ended running %s',filename),'Run solver','modal');
        end  
    end
    if data.Analysis.Impedances(5)>0
        filename = fullfile(data.Path,strcat(data.Name,'_ry.dat'));
        if ~exist(filename,'file')
            uiwait(msgbox('You have to first generate the input file','Run solver','modal'));
            return;
        end
        if isunix || ismac
            strcommand = sprintf('./piledyn_solver -f %s',filename);
        elseif ispc
            strcommand = sprintf('piledyn_solver.exe -f %s',filename);
        end 
        [status,~] = system(strcommand,'-echo');
        if status~=0
            disp(status)
            errordlg('Some error ocurred trying to run the solver','Run solver','modal')
        else
            msgbox(sprintf('Solver has ended running %s',filename),'Run solver','modal');
        end
    end
else
    errordlg(sprintf('Not defined yet: %s.',str), 'Solver input files', 'modal');
end

function RunProgram_DeleteFcn(hObject, eventdata, handles)
% hObject    handle to RunProgram (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

%_________________________________________________________________________%

% RAM MEMORY NEEDED

% --- Executes during object creation, after setting all properties.
function textRAM_CreateFcn(hObject, eventdata, handles)
% hObject    handle to textRAM (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

%_________________________________________________________________________%
%_________________________________________________________________________%

% --- Executes when user attempts to close figure1.
function figure1_CloseRequestFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: delete(hObject) closes the figure
if isequal(get(hObject, 'waitstatus'), 'waiting')
    % The GUI is still in UIWAIT, us UIRESUME
    uiresume(hObject);
else
    % The GUI is no longer waiting, just close it
    delete(hObject);
end


%_________________________________________________________________________%
%_________________________________________________________________________%


% --- Executes on button press in pushbuttonIntPoints.
function pushbuttonIntPoints_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonIntPoints (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
data = handles.figure1.UserData;
% Check requirements
ch = true;
str = '';
if isempty(data.Soil)
    ch = false;
    str = strcat(str,'<Soil>');
end
if isempty(data.PileGroup)
    ch = false;
    str = strcat(str,'<Pile group>');
end
% Write intersection points
if ch
    fich = strcat(data.Name,'_ip.txt');
    fil = fopen(fullfile(data.Path,fich),'w');
    for kl = 1:data.Soil.N
        for kp = 1:data.PileGroup.N
            % Find local coordinate of the intersection between the pile
            % and surface. Pile head is at t=0 and tip at t=1.
            z = data.Soil.layer(kl).z;
            head = data.PileGroup.Pile(kp).xhead;
            tip = data.PileGroup.Pile(kp).xtip;
            t = (z-head(3))/(tip(3)-head(3));
            if t>=0 && t<=1
                x=(1-t)*head(1) + t*tip(1);
                y=(1-t)*head(2) + t*tip(2);
                fprintf(fil,'%25.16e %25.16e %25.16e\n',x,y,z);
            end
        end
    end
    fclose(fil);
else
    errordlg(sprintf('Not defined yet: %s.',str), 'Mesh generation', 'modal');
end
