function [NodesX,ElementNodes,ElementNNodes,ElementDim,ElementSurface] =...
    GenerateOneQuarterMesh_3D(...
    NLayers,LayerTopZ,LastLayerBedrock,LayerCS,...
    NPiles,PilesHeadX,PilesTipX,PilesD,...
    freq_f,ratio_R,ratio_r,add_D,NEPLNear,NELONear,NEPLFar,NELOFar)
   
    % If LastLayerBedrock, then the corresponding LayerCS is ignored 
    % (->infty)

    % NPiles, PilesHeadX(pile,coord), PilesTipX(pile,coord) refer only to 
    % piles in the 1/4 symmetry discretization.
    
    % Frequency freq_f in Hz (scalar)
    
    % Maximum foundation dimension is taken from the bounding box
    Points = [PilesHeadX;PilesTipX];
    MaxFoundDimX = 2*(max(Points(:,1))-min(Points(:,1)));
    MaxFoundDimY = 2*(max(Points(:,2))-min(Points(:,2)));
    MaxFoundDimZ = max(Points(:,3))-min(Points(:,3));
    MaxFoundDim = max([MaxFoundDimX MaxFoundDimY MaxFoundDimZ]);

    % Generate mesh for each surface (nº surfaces == nº layers)
    for kSurface = 1:NLayers

        % Build pile points at surface (if it intersects the surface)
        counter = 1;
        for kPile = 1:NPiles
            % Find local coordinate of the intersection between the pile
            % and surface. Pile head is at t=0 and tip at t=1.
            z = LayerTopZ(kSurface);
            head = PilesHeadX(kPile,:);
            tip = PilesTipX(kPile,:);
            t = (z-head(3))/(tip(3)-head(3));
            if t>=0 && t<=1
                p(counter,1) = (1-t)*head(1) + t*tip(1);
                p(counter,2) = (1-t)*head(2) + t*tip(2);
                counter = counter + 1;
            end
        end
        R = MaxFoundDim*ratio_R(kSurface);
        r1 = max([max(p(:,1))*ratio_r(kSurface) max(p(:,1))+add_D(kSurface)*max(PilesD)]);
        r2 = max([max(p(:,2))*ratio_r(kSurface) max(p(:,2))+add_D(kSurface)*max(PilesD)]);

        if kSurface == 1
            cs = LayerCS(kSurface);
            MeshSizeNear = (cs/freq_f)/NELONear(kSurface);
            MeshSizeFar  = (cs/freq_f)/NELOFar(kSurface);
        else
            if kSurface == NLayers && LastLayerBedrock
                cs = LayerCS(kSurface-1);
                MeshSizeNear = (cs/freq_f)/NELONear(kSurface);
                MeshSizeFar  = (cs/freq_f)/NELOFar(kSurface);
            else
                cs = min([LayerCS(kSurface-1) LayerCS(kSurface)]);
                MeshSizeNear = (cs/freq_f)/NELONear(kSurface);
                MeshSizeFar  = (cs/freq_f)/NELOFar(kSurface);
            end
        end
        
        MeshSizeNear = min([MeshSizeNear max(PilesD)/NEPLNear(kSurface)]);
        MeshSizeFar = min([MeshSizeFar R/NEPLFar(kSurface)]);
        
        [nx,en,es] = GenerateOneQuarterMesh_2D(p,R,r1,r2,MeshSizeNear,MeshSizeFar);
        NNodes = length(nx(:,1));
        NElements = length(en(:,1));
        enn = 3*ones(NElements,1);
        ed = 2*ones(NElements,1);
        nx = [nx,LayerTopZ(kSurface)*ones(NNodes,1)];

        if kSurface == 1
            NodesX = nx;
            ElementNodes = en;
            ElementNNodes = enn;
            ElementDim = ed;
            ElementSurface = es;
        else
            NNodesPrevious = length(NodesX(:,1));
            NodesX = [NodesX;nx];
            ElementNodes = [ElementNodes;en+NNodesPrevious];
            ElementNNodes = [ElementNNodes;enn];
            ElementDim = [ElementDim;ed];
            ElementSurface = [ElementSurface;es+2*(kSurface-1)];
        end
    end
    
    %
    % Transform to quadratic mesh
    %
    disp('Converting to quadratic ...')
    [NodesX,ElementNodes,ElementNNodes] = TransformToQuadratic(NodesX,ElementNodes,ElementNNodes,ElementDim);
    disp('... done.')
end

