function [nodeCoordinates,elementNodes,elementSurface] = ...
    GenerateOneQuarterMesh_2D(p,R,r1,r2,MeshSizeNear,MeshSizeFar)
    %
    % Closing part
    %
    
    RExt = R + 0.7*MeshSizeFar;
    NArcEdges = max([3 ceil((pi/2)*RExt/MeshSizeFar)]);
    RExt = R + 0.7*(pi/2)*RExt/NArcEdges;
    NArcEdges = max([3 ceil((pi/2)*RExt/MeshSizeFar)]);
    
    % Falla para frecuencias bajas pq general varias lineas de elemnetos
    
    
    NArcPoints = NArcEdges+1;
    ClosingPoints = zeros(2*NArcPoints,2);
    for NodeCounter=1:NArcPoints
        angle = (pi/2)*(NodeCounter-1)/NArcEdges;
        ClosingPoints(NodeCounter          ,1) = RExt*cos(angle);
        ClosingPoints(NodeCounter          ,2) = RExt*sin(angle);
        ClosingPoints(NodeCounter+NArcPoints,1) = R*cos(pi/2-angle);
        ClosingPoints(NodeCounter+NArcPoints,2) = R*sin(pi/2-angle);
    end
    ClosingEdges = zeros(2*NArcEdges+2,2);
    for ElementCounter=1:NArcEdges
        ClosingEdges(ElementCounter,1) = ElementCounter;
        ClosingEdges(ElementCounter,2) = ElementCounter+1;
        ClosingEdges(ElementCounter+NArcEdges+1,1) = NArcPoints+ElementCounter;
        ClosingEdges(ElementCounter+NArcEdges+1,2) = NArcPoints+ElementCounter+1;
    end
    ClosingEdges(NArcEdges+1,1) = NArcPoints;
    ClosingEdges(NArcEdges+1,2) = NArcPoints+1;
    ClosingEdges(2*NArcEdges+2,1) = 2*NArcPoints;
    ClosingEdges(2*NArcEdges+2,2) = 1;
    ClosingPart = 1:2*NArcEdges+2;
    NClosingPoints = length(ClosingPoints(:,1));
    NClosingEdges = length(ClosingEdges(:,1));
    %
    % Transition part
    %
    TransitionAdditionalPoints = [0,r2;r1,r2;r1,0];
    TransitionAdditionalEdges = [NArcPoints+1 NClosingPoints+1
                                 NClosingPoints+1 NClosingPoints+2
                                 NClosingPoints+2 NClosingPoints+3
                                 NClosingPoints+3 NClosingPoints];
    NTransitionAdditionalPoints = 3;
    NTransitionAdditionalEdges = 4;
    TransitionPart = [(NArcEdges+2):(NClosingEdges-1) (NClosingEdges+1):(NClosingEdges+4)];
    %
    % Interior part
    %
    pX0 = [];
    pY0 = [];
    pInterior = [];
    if ~isempty(p)
        % First classify points p for constraints in the near field
        % Error if p contain points outside interior part
        for kp = 1:length(p(:,1))
            if p(kp,1)>=r1 || p(kp,2)>=r2 ||  p(kp,1)<-1.0E-6 || p(kp,2)<-1.0E-6
                error ('Constraint points in the near field are invalid points')
            end
        end
        % Points at x=0
        pCounter = 1;
        for kp = 1:length(p(:,1))
            if abs(p(kp,1))<1.E-6 && p(kp,2)>0
                pX0(pCounter,1) = 0;
                pX0(pCounter,2) = p(kp,2);
                pCounter = pCounter + 1;
            end
        end
        % Points at y=0
        pCounter = 1;
        for kp = 1:length(p(:,1))
            if p(kp,1)>0 && abs(p(kp,2))<1.E-6
                pY0(pCounter,1) = p(kp,1);
                pY0(pCounter,2) = 0;
                pCounter = pCounter + 1;
            end
        end
        % Purely interior points
        pCounter = 1;
        for kp = 1:length(p(:,1))
            if p(kp,1)>0 && p(kp,2)>0
                pInterior(pCounter,:) = p(kp,:);
                pCounter = pCounter + 1;
            end
        end
    end
    % Build points and edges
    InteriorEdgePoints = [];
    if ~isempty(pX0)
        pX0 = [pX0(:,1),sort(pX0(:,2),'descend')];
        InteriorEdgePoints = [pX0];
    end
    InteriorEdgePoints = [InteriorEdgePoints;[0,0]];
    if ~isempty(pY0)
        pY0 = [sort(pY0(:,1),'ascend'),pY0(:,2)];
        InteriorEdgePoints = [InteriorEdgePoints;pY0];
    end
    NEdgePoints = length(InteriorEdgePoints(:,1));
    InteriorPoints = [InteriorEdgePoints;pInterior];
    % Build new edges
    InteriorEdges = zeros(NEdgePoints+2-1,2);
    for ke=1:NEdgePoints+2-1
        if ke == 1
            InteriorEdges(ke,1) = NClosingPoints+1;
        else
            InteriorEdges(ke,1) = NClosingPoints+4+ke-2;
        end
        if ke == NEdgePoints+2-1
            InteriorEdges(ke,2) = NClosingPoints+3;
        else
            InteriorEdges(ke,2) = NClosingPoints+4+ke-1;
        end
    end
    % Build the part
    InteriorPart = [NClosingEdges+2 NClosingEdges+3 NClosingEdges+5:(NClosingEdges+4+NEdgePoints+2-1)];
    node = [ClosingPoints;TransitionAdditionalPoints;InteriorPoints];
    edge = [ClosingEdges;TransitionAdditionalEdges;InteriorEdges];
    part{1} = ClosingPart;
    part{2} = TransitionPart;
    part{3} = InteriorPart;
    % Mesh generation
    opts.kind = 'delfront';
    [vert,etri,tria,tnum] = refine2(node,edge,part,[],...
       @SizeOneQuarterMesh,R,r1,r2,MeshSizeNear,MeshSizeFar); 

%     % Plot
%     figure;
%     patch('faces',tria(:,1:3),...
%         'vertices',vert, ...
%         'facecolor','w', ...
%         'edgecolor',[.2,.2,.2]);
%     hold on; 
%     axis image off;
%     patch('faces',edge(:,1:2),...
%         'vertices',node, ...
%         'facecolor','w', ...
%         'edgecolor',[.1,.1,.1], ...
%         'linewidth',1.5);  
    % Build final variables
    % Coordinates of nodes
    nodeCoordinates = vert;
    % Surface number and nodes of each element
    % Set 1 to the surface, and 2 to the closure elements
%

    tnum(find(tnum==1)) = 4;
    tnum(find(tnum==2)) = 5;
    tnum(find(tnum==3)) = 6;
    tnum(find(tnum==4)) = 2;
    tnum(find(tnum==5)) = 1;
    tnum(find(tnum==6)) = 1;
    [~,idx] = sort(tnum,'ascend');
    elementSurface = tnum(idx);
    elementNodes = tria(idx,:);
end

function [HH] = SizeOneQuarterMesh(PP,R,r1,r2,MeshSizeNear,MeshSizeFar)
    NPoints = length(PP(:,1));
    r = sqrt(r1^2+r2^2);
    HH = zeros(NPoints,1);
    for kp=1:NPoints
        x = PP(kp,:);
        rho = sqrt(dot(x,x));
        if x(1)<=r1
            if x(2)<=r2
                HH(kp) = MeshSizeNear;
            else
                if x(2)>R
                    HH(kp) = MeshSizeFar;
                else
                    t = (x(2)-r2)/(R-r2);
                    HH(kp) = (1-t)*MeshSizeNear+t*MeshSizeFar;
                end
            end
        else
            if x(2)<=r2
                if x(1)<=r1
                    HH(kp) = MeshSizeNear;
                else
                    if x(1)>R
                        HH(kp) = MeshSizeFar;
                    else
                        t = (x(1)-r1)/(R-r1);
                        HH(kp) = (1-t)*MeshSizeNear+t*MeshSizeFar;
                    end
                end
            else
                if rho<=r
                    HH(kp) = MeshSizeNear;
                else
                    if rho>R
                        HH(kp) = MeshSizeFar;
                    else
                        t = (rho-r)/(R-r);
                        HH(kp) = (1-t)*MeshSizeNear+t*MeshSizeFar;
                    end
                end
            end
        end
    end
end
