function varargout = Frequencies(varargin)
%FREQUENCIES MATLAB code file for Frequencies.fig
%      FREQUENCIES, by itself, creates a new FREQUENCIES or raises the existing
%      singleton*.
%
%      H = FREQUENCIES returns the handle to a new FREQUENCIES or the handle to
%      the existing singleton*.
%
%      FREQUENCIES('Property','Value',...) creates a new FREQUENCIES using the
%      given property value pairs. Unrecognized properties are passed via
%      varargin to Frequencies_OpeningFcn.  This calling syntax produces a
%      warning when there is an existing singleton*.
%
%      FREQUENCIES('CALLBACK') and FREQUENCIES('CALLBACK',hObject,...) call the
%      local function named CALLBACK in FREQUENCIES.M with the given input
%      arguments.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help Frequencies

% Last Modified by GUIDE v2.5 04-Oct-2017 17:08:02

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @Frequencies_OpeningFcn, ...
                   'gui_OutputFcn',  @Frequencies_OutputFcn, ...
                   'gui_LayoutFcn',  [], ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
   gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before Frequencies is made visible.
function Frequencies_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   unrecognized PropertyName/PropertyValue pairs from the
%            command line (see VARARGIN)

% Initialize with the given data structure or a default structure
% Default values

% Frequencies
freq=struct('type',1,...       % Flag to know what is saved in 'value': 1) a0, 2) w, 3) f
            'value',[],...     % Vector of frequencies
            'ref',1,...        % Reference for a0: 1) D,c, 2) w_ref, 3) f_ref
            'ref_data',[1 1]); % Data for the a0 reference (vector form)       

% Pre-defined values for a0 reference (custom values)
defaultopt = struct('name','Custom','value',1,'editable',true);
predefopt=struct('D',[defaultopt],'c',[defaultopt],'w_ref',[defaultopt],'f_ref',[defaultopt]);
additional_options=[];
switch length(varargin)
    case 0
        handles.pushbuttonCancel.UserData=[];
    case 1
        if ~isempty(varargin{1})
            freq=varargin{1};
            handles.pushbuttonCancel.UserData=freq;
        else
            handles.pushbuttonCancel.UserData=[];
        end
    case 2
        if ~isempty(varargin{1})
            freq=varargin{1};
            handles.pushbuttonCancel.UserData=freq;
        end
        if ~isempty(varargin{2})
            additional_options=varargin{2};
        end
end

% Load a0 options to popupmenus
handles.popupmenuD.UserData = predefopt.D;
handles.popupmenuc.UserData = predefopt.c;
handles.popupmenuw_ref.UserData = predefopt.w_ref;
handles.popupmenuf_ref.UserData = predefopt.f_ref;

if freq.type==1
    switch freq.ref
        case 1
            handles.popupmenuD.UserData(1).value = freq.ref_data(1);
            handles.popupmenuc.UserData(1).value = freq.ref_data(2);
        case 2
            handles.popupmenuw_ref.UserData(1).value = freq.ref_data(1);
        case 3
            handles.popupmenuf_ref.UserData(1).value = freq.ref_data(1);
        otherwise
            error('Invalid value of *.ref')
    end
end
if ~isempty(additional_options)
    if isfield(additional_options,'D')
        for kf = 1:length(additional_options.D)
            handles.popupmenuD.UserData(1+kf)=additional_options.D(kf);
        end
    end
    if isfield(additional_options,'c')
        for kf = 1:length(additional_options.c)
            handles.popupmenuc.UserData(1+kf)=additional_options.c(kf);
        end
    end
    if isfield(additional_options,'w_ref')
        for kf = 1:length(additional_options.w_ref)
            handles.popupmenuw_ref.UserData(1+kf)=additional_options.w_ref(kf);
        end
    end
    if isfield(additional_options,'f_ref')
        for kf = 1:length(additional_options.f_ref)
            handles.popupmenuf_ref.UserData(1+kf)=additional_options.f_ref(kf);
        end
    end

end
% D
listString=sprintf("%s",handles.popupmenuD.UserData(1).name);
for kf = 2:length(handles.popupmenuD.UserData)
    tmpstr=sprintf("|%s",handles.popupmenuD.UserData(kf).name);
    listString=strcat(listString,tmpstr);
end
handles.popupmenuD.String=listString;
% c
listString=sprintf("%s",handles.popupmenuc.UserData(1).name);
for kf = 2:length(handles.popupmenuc.UserData)
    tmpstr=sprintf("|%s",handles.popupmenuc.UserData(kf).name);
    listString=strcat(listString,tmpstr);
end
handles.popupmenuc.String=listString;
% w_ref
listString=sprintf("%s",handles.popupmenuw_ref.UserData(1).name);
for kf = 2:length(handles.popupmenuw_ref.UserData)
    tmpstr=sprintf("|%s",handles.popupmenuw_ref.UserData(kf).name);
    listString=strcat(listString,tmpstr);
end
handles.popupmenuw_ref.String=listString;
% f_ref
listString=sprintf("%s",handles.popupmenuf_ref.UserData(1).name);
for kf = 2:length(handles.popupmenuf_ref.UserData)
    tmpstr=sprintf("|%s",handles.popupmenuf_ref.UserData(kf).name);
    listString=strcat(listString,tmpstr);
end
handles.popupmenuf_ref.String=listString;

handles.figure1.UserData = freq;

handles.popupmenutype.Value = freq.type;
handles.popupmenureference.Value = freq.ref;
updateListbox(handles,[]);
updateAxes(handles);
updateFreqType(handles);

% Default values for Generator
handles.editGeneratorType.Value = 1;
handles.editGeneratorMin.String = '0.1';
handles.editGeneratorMin.Value = 0.1;
handles.editGeneratorMax.String = '1';
handles.editGeneratorMax.Value = 1;
handles.editGeneratorN.String = '10';
handles.editGeneratorN.Value = 10;

handles.pushbuttonAccept.UserData = 0;

% Choose default command line output for Frequencies
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);
movegui(hObject,'center');

% UIWAIT makes Frequencies wait for user response (see UIRESUME)
uiwait(handles.figure1);

function updateListbox(handles,active)
% Reorder frequencies
handles.figure1.UserData.value = sort(unique(handles.figure1.UserData.value),'ascend');
freq = handles.figure1.UserData;
if length(freq.value)>0
    listString=sprintf("%g",freq.value(1));
    for kf = 2:length(freq.value)
        tmpstr=sprintf("|%g",freq.value(kf));
        listString=strcat(listString,tmpstr);
    end
    handles.listboxFrequencies.String=listString;
    if isempty(active)
        handles.listboxFrequencies.Value = 1;
    else
        if active>0 && active<=length(freq.value)
            handles.listboxFrequencies.Value = active;
        else
            if active <=0
                handles.listboxFrequencies.Value = 1;
            else
                handles.listboxFrequencies.Value = length(freq.value);
            end
        end
    end
    handles.editFrequency.String = sprintf('%g',freq.value(handles.listboxFrequencies.Value));
else
    handles.listboxFrequencies.String = '';
    handles.listboxFrequencies.Value = 0;
    handles.editFrequency.String = '';
end



function updateAxes(handles)
freq = handles.figure1.UserData;
if handles.popupmenuXScale.Value == 1
    plot (freq.value,zeros(1,length(freq.value)),'.')
else
    semilogx (freq.value,zeros(1,length(freq.value)),'.')
end
if length(freq.value)>1
    if max(freq.value)-min(freq.value)>0
    set(handles.axes1,'XLim',[min(freq.value) max(freq.value)])
    end
end
set(handles.axes1,'YLim',[-1 1])
yticks(handles.axes1,[]);
set(handles.axes1,'Box','on')
switch freq.type
    case 1
        xlabel(handles.axes1,'a_0')
    case 2
        xlabel(handles.axes1,'w')
    case 3
        xlabel(handles.axes1,'f')
    otherwise
        error('Invalid .type') 
end
ylabel(handles.axes1,'')    





function updateFreqType(handles)
freq = handles.figure1.UserData;
freq.type = handles.popupmenutype.Value;
switch freq.type
    case 1
        handles.popupmenureference.Enable = 'on';
        updateRefType(handles);
        handles.textedit.String = 'Selection: a_0 =';
    case 2
        handles.popupmenureference.Enable = 'off';
        handles.popupmenuD.Enable = 'off';
        handles.editD.Enable = 'off';
        handles.editD.String = '';
        handles.popupmenuc.Enable = 'off';
        handles.editc.Enable = 'off';
        handles.editc.String = '';
        handles.popupmenuw_ref.Enable = 'off';
        handles.editw_ref.Enable = 'off';
        handles.editw_ref.String = '';
        handles.popupmenuf_ref.Enable = 'off';
        handles.editf_ref.Enable = 'off';  
        handles.editf_ref.String = '';
        handles.textedit.String = 'Selection: w =';
        freq.ref = [];
        freq.ref_data = [];
        handles.figure1.UserData = freq;
    case 3
        handles.popupmenureference.Enable = 'off';
        handles.popupmenuD.Enable = 'off';
        handles.editD.Enable = 'off';
        handles.editD.String = '';
        handles.popupmenuc.Enable = 'off';
        handles.editc.Enable = 'off';
        handles.editc.String = '';
        handles.popupmenuw_ref.Enable = 'off';
        handles.editw_ref.Enable = 'off';
        handles.editw_ref.String = '';
        handles.popupmenuf_ref.Enable = 'off';
        handles.editf_ref.Enable = 'off';
        handles.editf_ref.String = ''; 
        handles.textedit.String = 'Selection: f =';
        freq.ref = [];
        freq.ref_data = [];
        handles.figure1.UserData = freq;
    otherwise
        error('Invalid *.type')
end




function updateRefType(handles)
freq = handles.figure1.UserData;
freq.ref = handles.popupmenureference.Value;
freq.ref_data = [];


% hay que cargar los valores de entrada en la estructura de datos de
% opciones



switch freq.ref
    case 1
        

        handles.popupmenuD.Enable = 'on';
        active = handles.popupmenuD.Value;
        freq.ref_data(1) = handles.popupmenuD.UserData(active).value;
        if handles.popupmenuD.UserData(active).editable
            handles.editD.Enable = 'on';
        else
            handles.editD.Enable = 'inactive';
        end
        handles.editD.String = sprintf('%g',freq.ref_data(1));

        handles.popupmenuc.Enable = 'on';
        active = handles.popupmenuc.Value;
        freq.ref_data(2) = handles.popupmenuc.UserData(active).value;
        if handles.popupmenuc.UserData(active).editable
            handles.editc.Enable = 'on';
        else
            handles.editc.Enable = 'inactive';
        end
        handles.editc.String = sprintf('%g',freq.ref_data(2));
        
        handles.editw_ref.Enable = 'off';
        handles.editw_ref.String = '';
        handles.popupmenuw_ref.Enable = 'off';
        
        handles.editf_ref.Enable = 'off';  
        handles.editf_ref.String = '';
        handles.popupmenuf_ref.Enable = 'off';
        
    case 2
        handles.editD.Enable = 'off';
        handles.editD.String = '';
        handles.popupmenuD.Enable = 'off';
        
        handles.editc.Enable = 'off';
        handles.editc.String = '';
        handles.popupmenuc.Enable = 'off';
        
        handles.popupmenuw_ref.Enable = 'on';
        active = handles.popupmenuw_ref.Value;
        freq.ref_data(1) = handles.popupmenuw_ref.UserData(active).value;
        if handles.popupmenuw_ref.UserData(active).editable
            handles.editw_ref.Enable = 'on';
        else
            handles.editw_ref.Enable = 'inactive';
        end
        handles.editw_ref.String = sprintf('%g',freq.ref_data(1));
        
        handles.editf_ref.Enable = 'off';  
        handles.editf_ref.String = '';
        handles.popupmenuf_ref.Enable = 'off';
        
    case 3
        handles.editD.Enable = 'off';
        handles.editD.String = '';
        handles.popupmenuD.Enable = 'off';
        
        handles.editc.Enable = 'off';
        handles.editc.String = '';
        handles.popupmenuc.Enable = 'off';
        
        handles.editw_ref.Enable = 'off';
        handles.editw_ref.String = '';
        handles.popupmenuw_ref.Enable = 'off';
        
        handles.popupmenuf_ref.Enable = 'on';
        active = handles.popupmenuf_ref.Value;
        freq.ref_data(1) = handles.popupmenuf_ref.UserData(active).value;
        if handles.popupmenuf_ref.UserData(active).editable
            handles.editf_ref.Enable = 'on';
        else
            handles.editf_ref.Enable = 'inactive';
        end
        handles.editf_ref.String = sprintf('%g',freq.ref_data(1));
        
    otherwise
        error('Invalid .ref')
end
handles.figure1.UserData = freq;

% --- Outputs from this function are returned to the command line.
function varargout = Frequencies_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
if round(handles.pushbuttonAccept.UserData)==1
    freq=handles.figure1.UserData;
else
    freq=handles.pushbuttonCancel.UserData;
end
varargout{1} = freq;
delete(handles.figure1);


% --- Executes during object creation, after setting all properties.
function figure1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called


% --- Executes when user attempts to close figure1.
function figure1_CloseRequestFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: delete(hObject) closes the figure
if isequal(get(hObject, 'waitstatus'), 'waiting')
    % The GUI is still in UIWAIT, us UIRESUME
    uiresume(hObject);
else
    % The GUI is no longer waiting, just close it
    delete(hObject);
end



function editGeneratorMax_Callback(hObject, eventdata, handles)
% hObject    handle to editGeneratorMax (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editGeneratorMax as text
%        str2double(get(hObject,'String')) returns contents of editGeneratorMax as a double
hObject.BackgroundColor = get(0,'defaultUicontrolBackgroundColor');
CheckNumericEdit(0,'<' ,hObject,'<',Inf,false);

% --- Executes during object creation, after setting all properties.
function editGeneratorMax_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editGeneratorMax (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function editFrequency_Callback(hObject, eventdata, handles)
% hObject    handle to editFrequency (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editFrequency as text
%        str2double(get(hObject,'String')) returns contents of editFrequency as a double
hObject.BackgroundColor = get(0,'defaultUicontrolBackgroundColor');
CheckNumericEdit(0,'<' ,handles.editFrequency,'<',Inf,false);




% --- Executes during object creation, after setting all properties.
function editFrequency_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editFrequency (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in listboxFrequencies.
function listboxFrequencies_Callback(hObject, eventdata, handles)
% hObject    handle to listboxFrequencies (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns listboxFrequencies contents as cell array
%        contents{get(hObject,'Value')} returns selected item from listboxFrequencies
active = handles.listboxFrequencies.Value;
handles.editFrequency.BackgroundColor = [0.94 0.94 0.94];
handles.editFrequency.String = sprintf('%g',handles.figure1.UserData.value(active));



% --- Executes during object creation, after setting all properties.
function listboxFrequencies_CreateFcn(hObject, eventdata, handles)
% hObject    handle to listboxFrequencies (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function editGeneratorN_Callback(hObject, eventdata, handles)
% hObject    handle to editGeneratorN (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editGeneratorN as text
%        str2double(get(hObject,'String')) returns contents of editGeneratorN as a double
hObject.BackgroundColor = get(0,'defaultUicontrolBackgroundColor');
CheckNumericEdit(2,'<=' ,hObject,'<',Inf,true);

% --- Executes during object creation, after setting all properties.
function editGeneratorN_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editGeneratorN (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in popupmenutype.
function popupmenutype_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenutype (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns popupmenutype contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenutype
updateFreqType(handles);
updateAxes(handles);



% --- Executes during object creation, after setting all properties.
function popupmenutype_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenutype (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbuttonAccept.
function pushbuttonAccept_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonAccept (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if isempty(handles.figure1.UserData.value)
    errordlg('No frequencies defined', 'Error', 'modal');
else
    hObject.UserData = 1;
    figure1_CloseRequestFcn(handles.figure1, eventdata, handles);
end


% --- Executes on button press in pushbuttonCancel.
function pushbuttonCancel_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonCancel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
figure1_CloseRequestFcn(handles.figure1, eventdata, handles)


function editD_Callback(hObject, eventdata, handles)
% hObject    handle to editD (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editD as text
%        str2double(get(hObject,'String')) returns contents of editD as a double
hObject.BackgroundColor = get(0,'defaultUicontrolBackgroundColor');
if CheckNumericEdit(0,'<' ,hObject,'<',Inf,false)
    handles.figure1.UserData.ref_data(1) = str2double(hObject.String);
end

% --- Executes during object creation, after setting all properties.
function editD_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editD (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function editc_Callback(hObject, eventdata, handles)
% hObject    handle to editc (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editc as text
%        str2double(get(hObject,'String')) returns contents of editc as a double
hObject.BackgroundColor = get(0,'defaultUicontrolBackgroundColor');
if CheckNumericEdit(0,'<' ,hObject,'<',Inf,false)
    handles.figure1.UserData.ref_data(2) = str2double(hObject.String);
end

% --- Executes during object creation, after setting all properties.
function editc_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editc (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function editw_ref_Callback(hObject, eventdata, handles)
% hObject    handle to editw_ref (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editw_ref as text
%        str2double(get(hObject,'String')) returns contents of editw_ref as a double
hObject.BackgroundColor = get(0,'defaultUicontrolBackgroundColor');
if CheckNumericEdit(0,'<' ,hObject,'<',Inf,false)
    handles.figure1.UserData.ref_data(1) = str2double(hObject.String);
end

% --- Executes during object creation, after setting all properties.
function editw_ref_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editw_ref (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in popupmenureference.
function popupmenureference_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenureference (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns popupmenureference contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenureference
updateFreqType(handles);

% --- Executes during object creation, after setting all properties.
function popupmenureference_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenureference (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function editf_ref_Callback(hObject, eventdata, handles)
% hObject    handle to editf_ref (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editf_ref as text
%        str2double(get(hObject,'String')) returns contents of editf_ref as a double
hObject.BackgroundColor = get(0,'defaultUicontrolBackgroundColor');
if CheckNumericEdit(0,'<' ,hObject,'<',Inf,false)
    handles.figure1.UserData.ref_data(1) = str2double(hObject.String);
end

% --- Executes during object creation, after setting all properties.
function editf_ref_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editf_ref (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbuttonEditorAdd.
function pushbuttonEditorAdd_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonEditorAdd (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles.editFrequency.BackgroundColor=[0.94 0.94 0.94];
if CheckNumericEdit(0,'<' ,handles.editFrequency,'<',Inf,false)
    active = handles.listboxFrequencies.Value;
    freq = handles.figure1.UserData;
    freq_mod = freq;
    kfn=1;
    for kf=1:length(freq.value)
        freq_mod.value(kfn)=freq.value(kf);
        kfn=kfn+1;
        if kf==active
            kfn=kfn+1;
        end
    end
    freq_mod.value(active+1) = str2double(handles.editFrequency.String);
    [~,idx]=sort(freq_mod.value);
    handles.figure1.UserData = freq_mod;
    updateListbox(handles,find(idx==active+1));
    updateAxes(handles);
end

% --- Executes on button press in pushbuttonEditorRemove.
function pushbuttonEditorRemove_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonEditorRemove (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
active = handles.listboxFrequencies.Value;
freq = handles.figure1.UserData;
if length(freq.value)>1
    freq_mod = freq;
    kfn=1;
    for kf=1:length(freq.value)
        if kf~=active
            freq_mod.value(kfn)=freq.value(kf);
            kfn=kfn+1;
        end
    end
    freq_mod.value = freq_mod.value(1:length(freq.value)-1);
    freq = freq_mod;
    if active>1
        handles.listboxFrequencies.Value=active-1;
        active=active-1;
    end
    handles.figure1.UserData = freq;
    updateListbox(handles,active);
    updateAxes(handles);
else
    freq.value = [];
end
handles.figure1.UserData = freq;
updateListbox(handles,active);
updateAxes(handles);




% --- Executes on button press in pushbuttonEditorEdit.
function pushbuttonEditorEdit_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonEditorEdit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if CheckNumericEdit(0,'<' ,handles.editFrequency,'<',Inf,false)
    active = handles.listboxFrequencies.Value;
    handles.figure1.UserData.value(active) = str2double(handles.editFrequency.String);
    updateListbox(handles,active);
    updateAxes(handles);
end


function editGeneratorMin_Callback(hObject, eventdata, handles)
% hObject    handle to editGeneratorMin (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editGeneratorMin as text
%        str2double(get(hObject,'String')) returns contents of editGeneratorMin as a double
hObject.BackgroundColor = get(0,'defaultUicontrolBackgroundColor');
CheckNumericEdit(0,'<' ,hObject,'<',Inf,false);

% --- Executes during object creation, after setting all properties.
function editGeneratorMin_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editGeneratorMin (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in popupmenuGeneratorType.
function popupmenuGeneratorType_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenuGeneratorType (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns popupmenuGeneratorType contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenuGeneratorType


% --- Executes during object creation, after setting all properties.
function popupmenuGeneratorType_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenuGeneratorType (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbuttonGeneratorAdd.
function pushbuttonGeneratorAdd_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonGeneratorAdd (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles.editGeneratorMin.BackgroundColor=[0.94 0.94 0.94];
handles.editGeneratorMax.BackgroundColor=[0.94 0.94 0.94];
handles.editGeneratorN.BackgroundColor=[0.94 0.94 0.94];
ok = true;
if ~CheckNumericEdit(0,'<' ,handles.editGeneratorMin,'<',Inf,false)
    ok = false;
end
if ~CheckNumericEdit(0,'<' ,handles.editGeneratorMax,'<',Inf,false)
    ok = false;
end
if ~CheckNumericEdit(2,'<=' ,handles.editGeneratorN,'<',Inf,true)
    ok = false;
end
if ok
    minf = str2double(handles.editGeneratorMin.String);
    maxf = str2double(handles.editGeneratorMax.String);
    nf = str2double(handles.editGeneratorN.String);
    if maxf-minf<=0
        handles.editGeneratorMin.BackgroundColor=[1 0 0];
        handles.editGeneratorMax.BackgroundColor=[1 0 0];
    else
        % Generate frequencies
        switch handles.popupmenuGeneratorType.Value
            case 1
                fr = minf:(maxf-minf)/(nf-1):maxf;
            case 2
                lminf = log10(minf);
                lmaxf = log10(maxf);
                lfr = lminf:(lmaxf-lminf)/(nf-1):lmaxf;
                fr = 10.^lfr;
        end
        nfvalue = length(handles.figure1.UserData.value);
        handles.figure1.UserData.value((nfvalue+1):(nfvalue+nf))=fr;
        updateListbox(handles,nfvalue+nf);
        updateAxes(handles);
    end
    
end






% --- Executes on selection change in popupmenuXScale.
function popupmenuXScale_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenuXScale (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns popupmenuXScale contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenuXScale
updateAxes(handles);

% --- Executes during object creation, after setting all properties.
function popupmenuXScale_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenuXScale (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in popupmenuD.
function popupmenuD_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenuD (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns popupmenuD contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenuD
updateRefType(handles);

% --- Executes during object creation, after setting all properties.
function popupmenuD_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenuD (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in popupmenuc.
function popupmenuc_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenuc (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns popupmenuc contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenuc
updateRefType(handles);

% --- Executes during object creation, after setting all properties.
function popupmenuc_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenuc (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in popupmenuw_ref.
function popupmenuw_ref_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenuw_ref (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns popupmenuw_ref contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenuw_ref
updateRefType(handles);

% --- Executes during object creation, after setting all properties.
function popupmenuw_ref_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenuw_ref (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in popupmenuf_ref.
function popupmenuf_ref_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenuf_ref (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns popupmenuf_ref contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenuf_ref
updateRefType(handles);

% --- Executes during object creation, after setting all properties.
function popupmenuf_ref_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenuf_ref (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbuttonRemoveAll.
function pushbuttonRemoveAll_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonRemoveAll (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
freq = handles.figure1.UserData;
freq.value = [];
handles.figure1.UserData = freq;
updateListbox(handles,0);
updateAxes(handles);
