%TODO: dibujar circunferencias inclinadas en vez de horizontales en cabeza
%y punta del pilote



function varargout = Configuration(varargin)
% CONFIGURATION MATLAB code for Configuration.fig
%      CONFIGURATION, by itself, creates a new CONFIGURATION or raises the existing
%      singleton*.
%
%      H = CONFIGURATION returns the handle to a new CONFIGURATION or the handle to
%      the existing singleton*.
%
%      CONFIGURATION('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in CONFIGURATION.M with the given input arguments.
%
%      CONFIGURATION('Property','Value',...) creates a new CONFIGURATION or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before Configuration_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to Configuration_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help Configuration

% Last Modified by GUIDE v2.5 04-Oct-2017 17:09:21

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @Configuration_OpeningFcn, ...
                   'gui_OutputFcn',  @Configuration_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before Configuration is made visible.
function Configuration_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to Configuration (see VARARGIN)

% Initialize with the given data structure or a default structure
if length(varargin)==1 && ~isempty(varargin{1})
    RegularPileGroup=varargin{1};
    handles.figure1.UserData=RegularPileGroup;
else
    handles.figure1.UserData=[];
    % Default values
    RegularPileGroup=struct('type','regular',...
                            'Nx',2,...                 % Number of piles in x direction
                            'Ny',2,...                 % Number of piles in y direction
                            'sx',1,...                 % Pile spacing in x direction
                            'sy',1,...                 % Pile spacing in y direction
                            'bx',1.5,...               % Cap length in x direction
                            'by',1.5,...               % Cap length in y direction
                            'l',10,...                 % Pile length                        
                            'Do',0.20,...              % Cross-section outer diameter
                            'Di',0.19,...              % Cross-section inner diameter
                            'E',210.e9,...             % Pile Young's modulus
                            'rho',7860,...             % Pile density
                            'Rake',1,...               % Rake: 1) none, 2) all piles, 3)outer piles
                            'RakeDirection',1,...      % Rake direction: 1) along x, 2) along y, 3) cap diagonal 
                            'RakeAngle',0);            % Rake angle: -90<theta<90                 
end

handles.editNx.String =sprintf('%g',RegularPileGroup.Nx);
handles.editNy.String =sprintf('%g',RegularPileGroup.Ny);
handles.editsx.String =sprintf('%g',RegularPileGroup.sx);
handles.editsy.String =sprintf('%g',RegularPileGroup.sy);
handles.editbx.String =sprintf('%g',RegularPileGroup.bx);
handles.editby.String =sprintf('%g',RegularPileGroup.by);
handles.editl.String  =sprintf('%g',RegularPileGroup.l);
handles.editDo.String =sprintf('%g',RegularPileGroup.Do);
handles.editDi.String =sprintf('%g',RegularPileGroup.Di);
handles.editE.String  =sprintf('%g',RegularPileGroup.E);
handles.editrho.String=sprintf('%g',RegularPileGroup.rho);
handles.popupmenuRake.Value=RegularPileGroup.Rake;
handles.popupmenuRakeDirection.Value=RegularPileGroup.RakeDirection;
handles.editRakeAngle.String=sprintf('%g',RegularPileGroup.RakeAngle);

if checkRegularPileGroup(handles)
    plotRegularPileGroup(handles)
else
    cla(handles.axes1)
end

handles.axes1.View=[30 30];
    
handles.pushbuttonAccept.UserData = 0;

% Choose default command line output for Configuration
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);
movegui(hObject,'center');

% UIWAIT makes Configuration wait for user response (see UIRESUME)
uiwait(handles.figure1);

function ok = checkRegularPileGroup(handles)
    ok = true;
    % Copy data in form to local variables
    Nx = round(str2double(handles.editNx.String));
    Ny = round(str2double(handles.editNy.String));
    sx = str2double(handles.editsx.String);
    sy = str2double(handles.editsy.String);
    bx = str2double(handles.editbx.String);
    by = str2double(handles.editby.String);
    l = str2double(handles.editl.String);
    Do = str2double(handles.editDo.String);
    Di = str2double(handles.editDi.String);
    E = str2double(handles.editE.String);
    rho = str2double(handles.editrho.String);
    Rake = handles.popupmenuRake.Value;
    RakeDirection = handles.popupmenuRakeDirection.Value;
    RakeAngle = str2double(handles.editRakeAngle.String);
    % Default color
    handles.editNx.BackgroundColor=[0.94 0.94 0.94];
    handles.editNy.BackgroundColor=[0.94 0.94 0.94];
    handles.editbx.BackgroundColor=[0.94 0.94 0.94];
    handles.editby.BackgroundColor=[0.94 0.94 0.94];
    handles.editsx.BackgroundColor=[0.94 0.94 0.94];
    handles.editsy.BackgroundColor=[0.94 0.94 0.94];
    handles.editl.BackgroundColor=[0.94 0.94 0.94];
    handles.editDo.BackgroundColor=[0.94 0.94 0.94];
    handles.editDi.BackgroundColor=[0.94 0.94 0.94];
    handles.editE.BackgroundColor=[0.94 0.94 0.94];
    handles.editrho.BackgroundColor=[0.94 0.94 0.94];
    handles.popupmenuRake.BackgroundColor=[0.94 0.94 0.94];
    handles.popupmenuRakeDirection.BackgroundColor=[0.94 0.94 0.94];
    handles.editRakeAngle.BackgroundColor=[0.94 0.94 0.94];
    handles.checkbox1.BackgroundColor=[0.94 0.94 0.94];
    handles.checkbox2.BackgroundColor=[0.94 0.94 0.94];
    % Check ranges of individual variables, and correct using last correct
    % values.
    if ~CheckNumericEdit(0  ,'<' ,handles.editNx ,'<',Inf,true)
        ok = false;
    end
    if ~CheckNumericEdit(0  ,'<' ,handles.editNy ,'<',Inf,true)
        ok = false;
    end
    if ~CheckNumericEdit(0  ,'<=',handles.editbx ,'<',Inf,false)
        ok = false;
    end
    if ~CheckNumericEdit(0  ,'<=',handles.editby ,'<',Inf,false)
        ok = false;
    end
    if ~CheckNumericEdit(0  ,'<=',handles.editsx ,'<',Inf,false)
        ok = false;
    end
    if ~CheckNumericEdit(0  ,'<=',handles.editsy ,'<',Inf,false)
        ok = false;
    end
    if ~CheckNumericEdit(0  ,'<' ,handles.editl  ,'<',Inf,false)
        ok = false;
    end
    if ~CheckNumericEdit(0  ,'<' ,handles.editDo ,'<',Inf,false)
        ok = false;
    end
    if ~CheckNumericEdit(0  ,'<=',handles.editDi ,'<',Inf,false)
        ok = false;
    end
    if ~CheckNumericEdit(0  ,'<' ,handles.editE  ,'<',Inf,false)
        ok = false;
    end
    if ~CheckNumericEdit(0  ,'<=',handles.editrho,'<',Inf,false)
        ok = false;
    end
    if ~CheckNumericEdit(-90,'<' ,handles.editRakeAngle,'<',90,false)
        ok = false;
    end
    % handles.popupmenuRake.Value, de 1 a 3
    % handles.popupmenuRakeDirection.Value, de 1 a 3
    
    % Check geometric compatibility
    c1=handles.checkbox1.Value;
    c2=handles.checkbox2.Value;
    % Perform checks and colorify cells
    if Do<=Di
        ok=false;
        handles.editDo.BackgroundColor=[1 0 0];
        handles.editDi.BackgroundColor=[1 0 0];
    end    
    if round(c1)==1
        if sx<=Do
            ok=false;
            handles.checkbox1.BackgroundColor=[1 0 0];
            handles.editDo.BackgroundColor=[1 0 0];
            handles.editsx.BackgroundColor=[1 0 0];
        end
        if sy<=Do
            ok=false;
            handles.checkbox1.BackgroundColor=[1 0 0];
            handles.editDo.BackgroundColor=[1 0 0];
            handles.editsy.BackgroundColor=[1 0 0];
        end
    end
    if round(c2)==1
        if (Nx-1)*sx+Do>=bx
            ok=false;
            handles.checkbox2.BackgroundColor=[1 0 0];
            handles.editNx.BackgroundColor=[1 0 0];
            handles.editsx.BackgroundColor=[1 0 0];
            handles.editDo.BackgroundColor=[1 0 0];
            handles.editbx.BackgroundColor=[1 0 0];
        end
        if (Ny-1)*sy+Do>=by
            ok=false;
            handles.checkbox2.BackgroundColor=[1 0 0];
            handles.editNy.BackgroundColor=[1 0 0];
            handles.editsy.BackgroundColor=[1 0 0];
            handles.editDo.BackgroundColor=[1 0 0];
            handles.editby.BackgroundColor=[1 0 0];
        end
    end

function plotRegularPileGroup(handles)
    % Copy data to local variables
    Nx = str2double(handles.editNx.String);
    Ny = str2double(handles.editNy.String);
    sx = str2double(handles.editsx.String);
    sy = str2double(handles.editsy.String);
    bx = str2double(handles.editbx.String);
    by = str2double(handles.editby.String);
    l = str2double(handles.editl.String);
    Do = str2double(handles.editDo.String);
    Di = str2double(handles.editDi.String);
    E = str2double(handles.editE.String);
    rho = str2double(handles.editrho.String);
    Rake = handles.popupmenuRake.Value;
    RakeDirection = handles.popupmenuRakeDirection.Value;
    RakeAngle = str2double(handles.editRakeAngle.String);
    % Initialize
    cla(handles.axes1)
    hold on
    % Draw symmetry axis
    x=[-0.75*bx 0.75*bx];
    y=[0 0];
    z=[0 0];
    plot3(x,y,z,'k-.')
    x=[0 0];
    y=[-0.75*by 0.75*by];
    z=[0 0];
    plot3(x,y,z,'k-.')
    % Draw cap
    x=[0.5*bx 0.5*bx 0];
    y=[0 0.5*by 0.5*by];
    z=[0 0 0];
    plot3(x,y,z,'b-','Linewidth',2)
    x=[0 -0.5*bx -0.5*bx 0.5*bx 0.5*bx];
    y=[0.5*by 0.5*by -0.5*by -0.5*by 0];
    z=[0 0 0 0 0];
    plot3(x,y,z,'b--')
    % Draw piles
    xref=-0.5*(Nx-1)*sx;
    yref=-0.5*(Ny-1)*sy;
    zref=0;
    for kpx=1:Nx
        for kpy=1:Ny
            % Pile head center
            xhead(1)=xref+sx*(kpx-1);
            xhead(2)=yref+sy*(kpy-1);
            xhead(3)=0;
            % Outer diameter
            theta=0:2*pi/21:2*pi;
            x=xhead(1)+0.5*Do*cos(theta);
            y=xhead(2)+0.5*Do*sin(theta);
            z=zeros(1,length(theta));
            if xhead(1)>=0 && xhead(2)>=0
                plot3(x,y,z,'r-','Linewidth',2)
            else
                plot3(x,y,z,'r-')
            end
            % Inner diameter
            if Di>0
                theta=0:2*pi/21:2*pi;
                x=xhead(1)+0.5*Di*cos(theta);
                y=xhead(2)+0.5*Di*sin(theta);
                z=zeros(1,length(theta));
                if xhead(1)>=0 && xhead(2)>=0
                    plot3(x,y,z,'r-','Linewidth',2)
                else
                    plot3(x,y,z,'r-')
                end
            end
            % Pile tip center
            % Rake direction for the present pile
            switch RakeDirection
                case 1
                    if xhead(1)<0
                        d = [-1 0];
                    elseif xhead(1)==0
                        d = [0 0];
                    else
                        d = [1 0];
                    end
                case 2
                    if xhead(2)<0
                        d = [0 -1];
                    elseif xhead(2)==0
                        d = [0 0];
                    else
                        d = [0 1];
                    end
                case 3
                    if sqrt(dot(xhead,xhead))==0
                        d = [0 0];
                    else
                        d = xhead/sqrt(dot(xhead,xhead));
                    end
                otherwise
                    error ('Not valid RakeDirection')
            end
            % Rake angle for the present pile
            switch Rake
                case 1
                    theta = 0; % no one is inclined
                case 2
                    theta = RakeAngle; % all are inclined
                case 3
                    if kpx==1 || kpx==Nx || kpy==1 || kpy==Ny
                        theta = RakeAngle;
                    else
                        theta = 0; % only outer
                    end
                otherwise
                    error ('Not valid Rake')
            end
            Lxp = l*sind(theta);
            xtip = xhead + [d(1)*Lxp d(2)*Lxp -l*cosd(theta)];
            % Save pile pile and tip center coordinates
            xhead_all(Nx*(kpy-1)+kpx,:) = xhead;
            xtip_all(Nx*(kpy-1)+kpx,:) = xtip;
            
            % Outer diameter
            r=xhead-xtip;
            pl=r/sqrt(dot(r,r));
            
            theta=0:2*pi/21:2*pi;
            x=xtip(1)+0.5*Do*cos(theta);
            y=xtip(2)+0.5*Do*sin(theta);
            z=xtip(3)*ones(1,length(theta));
            if xhead(1)>=0 && xhead(2)>=0
                plot3(x,y,z,'r-','Linewidth',2)
            else
                plot3(x,y,z,'r-')
            end
            % Inner diameter
            if Di>0
                theta=0:2*pi/21:2*pi;
                x=xtip(1)+0.5*Di*cos(theta);
                y=xtip(2)+0.5*Di*sin(theta);
                z=xtip(3)*ones(1,length(theta));
                if xhead(1)>=0 && xhead(2)>=0
                    plot3(x,y,z,'r-','Linewidth',2)
                else
                    plot3(x,y,z,'r-')
                end
            end
            % Line from head to tip
            if xhead(1)>=0 && xhead(2)>=0
                plot3([xhead(1) xtip(1)],[xhead(2) xtip(2)],[xhead(3) xtip(3)],'r-','Linewidth',2)
            else
                plot3([xhead(1) xtip(1)],[xhead(2) xtip(2)],[xhead(3) xtip(3)],'r-')
            end
        end
    end
    set(handles.axes1,'DataAspectRatio',[1 1 1])
    set(handles.axes1,'Box','on','BoxStyle','full')
    xlabel(handles.axes1,'x')
    ylabel(handles.axes1,'y')
    zlabel(handles.axes1,'z')
    handles.figure1.UserData.PileHeadX = xhead_all;
    handles.figure1.UserData.PileTipX = xtip_all;
    
    
    


% --- Outputs from this function are returned to the command line.
function varargout = Configuration_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure

if round(handles.pushbuttonAccept.UserData)==1
    RegularPileGroup.type = 'regular';
    RegularPileGroup.Nx = round(str2double(handles.editNx.String));
    RegularPileGroup.Ny = round(str2double(handles.editNy.String));
    RegularPileGroup.sx = str2double(handles.editsx.String);
    RegularPileGroup.sy = str2double(handles.editsy.String);
    RegularPileGroup.bx = str2double(handles.editbx.String);
    RegularPileGroup.by = str2double(handles.editby.String);
    RegularPileGroup.l = str2double(handles.editl.String);
    RegularPileGroup.Do = str2double(handles.editDo.String);
    RegularPileGroup.Di = str2double(handles.editDi.String);
    RegularPileGroup.E = str2double(handles.editE.String);
    RegularPileGroup.rho = str2double(handles.editrho.String);
    RegularPileGroup.Rake = handles.popupmenuRake.Value;
    RegularPileGroup.RakeDirection = handles.popupmenuRakeDirection.Value;
    RegularPileGroup.RakeAngle = str2double(handles.editRakeAngle.String);
    RegularPileGroup.PileHeadX = handles.figure1.UserData.PileHeadX;
    RegularPileGroup.PileTipX = handles.figure1.UserData.PileTipX;
else
    RegularPileGroup = handles.figure1.UserData;
end
varargout{1} = RegularPileGroup;
delete(handles.figure1);


% --- Executes on button press in pushbuttonAccept.
function pushbuttonAccept_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonAccept (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if ~checkRegularPileGroup(handles)
    set(hObject,'UserData',0)
    errordlg('This form contain errors and data cannot be saved','Form check','modal')
else
    set(hObject,'UserData',1)
    figure1_CloseRequestFcn(handles.figure1, eventdata, handles)
end

% --- Executes on button press in pushbuttonCancel.
function pushbuttonCancel_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonCancel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
figure1_CloseRequestFcn(handles.figure1, eventdata, handles)


function editNx_Callback(hObject, eventdata, handles)
% hObject    handle to editNx (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editNx as text
%        str2double(get(hObject,'String')) returns contents of editNx as a double
if checkRegularPileGroup(handles)
    plotRegularPileGroup(handles)
else
    cla(handles.axes1)
end



% --- Executes during object creation, after setting all properties.
function editNx_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editNx (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function editNy_Callback(hObject, eventdata, handles)
% hObject    handle to editNx (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editNx as text
%        str2double(get(hObject,'String')) returns contents of editNx as a double
if checkRegularPileGroup(handles)
    plotRegularPileGroup(handles)
else
    cla(handles.axes1)
end



% --- Executes during object creation, after setting all properties.
function editNy_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editNx (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function editsx_Callback(hObject, eventdata, handles)
% hObject    handle to editsx (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editsx as text
%        str2double(get(hObject,'String')) returns contents of editsx as a double
if checkRegularPileGroup(handles)
    plotRegularPileGroup(handles)
else
    cla(handles.axes1)
end



% --- Executes during object creation, after setting all properties.
function editsx_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editsx (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function editsy_Callback(hObject, eventdata, handles)
% hObject    handle to editsy (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editsy as text
%        str2double(get(hObject,'String')) returns contents of editsy as a double
if checkRegularPileGroup(handles)
    plotRegularPileGroup(handles)
else
    cla(handles.axes1)
end

% --- Executes during object creation, after setting all properties.
function editsy_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editsy (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function editby_Callback(hObject, eventdata, handles)
% hObject    handle to editby (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editby as text
%        str2double(get(hObject,'String')) returns contents of editby as a double
if checkRegularPileGroup(handles)
    plotRegularPileGroup(handles)
else
    cla(handles.axes1)
end

% --- Executes during object creation, after setting all properties.
function editby_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editby (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function editbx_Callback(hObject, eventdata, handles)
% hObject    handle to editbx (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editbx as text
%        str2double(get(hObject,'String')) returns contents of editbx as a double
if checkRegularPileGroup(handles)
    plotRegularPileGroup(handles)
else
    cla(handles.axes1)
end

% --- Executes during object creation, after setting all properties.
function editbx_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editbx (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function editl_Callback(hObject, eventdata, handles)
% hObject    handle to editl (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editl as text
%        str2double(get(hObject,'String')) returns contents of editl as a double
if checkRegularPileGroup(handles)
    plotRegularPileGroup(handles)
else
    cla(handles.axes1)
end

% --- Executes during object creation, after setting all properties.
function editl_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editl (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function editDo_Callback(hObject, eventdata, handles)
% hObject    handle to editDo (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editDo as text
%        str2double(get(hObject,'String')) returns contents of editDo as a double
if checkRegularPileGroup(handles)
    plotRegularPileGroup(handles)
else
    cla(handles.axes1)
end

% --- Executes during object creation, after setting all properties.
function editDo_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editDo (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function editE_Callback(hObject, eventdata, handles)
% hObject    handle to editE (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editE as text
%        str2double(get(hObject,'String')) returns contents of editE as a double
if checkRegularPileGroup(handles)
    plotRegularPileGroup(handles)
else
    cla(handles.axes1)
end

% --- Executes during object creation, after setting all properties.
function editE_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editE (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function editDi_Callback(hObject, eventdata, handles)
% hObject    handle to editDi (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editDi as text
%        str2double(get(hObject,'String')) returns contents of editDi as a double
if checkRegularPileGroup(handles)
    plotRegularPileGroup(handles)
else
    cla(handles.axes1)
end

% --- Executes during object creation, after setting all properties.
function editDi_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editDi (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function editrho_Callback(hObject, eventdata, handles)
% hObject    handle to editrho (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editrho as text
%        str2double(get(hObject,'String')) returns contents of editrho as a double
if checkRegularPileGroup(handles)
    plotRegularPileGroup(handles)
else
    cla(handles.axes1)
end

% --- Executes during object creation, after setting all properties.
function editrho_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editrho (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function editRakeAngle_Callback(hObject, eventdata, handles)
% hObject    handle to editRakeAngle (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editRakeAngle as text
%        str2double(get(hObject,'String')) returns contents of editRakeAngle as a double
if checkRegularPileGroup(handles)
    plotRegularPileGroup(handles)
else
    cla(handles.axes1)
end

% --- Executes during object creation, after setting all properties.
function editRakeAngle_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editRakeAngle (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in popupmenuRakeDirection.
function popupmenuRakeDirection_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenuRakeDirection (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns popupmenuRakeDirection contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenuRakeDirection
checkRegularPileGroup(handles);
plotRegularPileGroup(handles);

% --- Executes during object creation, after setting all properties.
function popupmenuRakeDirection_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenuRakeDirection (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in popupmenuRake.
function popupmenuRake_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenuRake (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns popupmenuRake contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenuRake
checkRegularPileGroup(handles);
plotRegularPileGroup(handles);

% --- Executes during object creation, after setting all properties.
function popupmenuRake_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenuRake (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in checkbox1.
function checkbox1_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox1
if checkRegularPileGroup(handles)
    plotRegularPileGroup(handles)
else
    cla(handles.axes1)
end

% --- Executes on button press in checkbox1.
function checkbox2_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox1
if checkRegularPileGroup(handles)
    plotRegularPileGroup(handles)
else
    cla(handles.axes1)
end


% --- Executes when user attempts to close figure1.
function figure1_CloseRequestFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: delete(hObject) closes the figure
if isequal(get(hObject, 'waitstatus'), 'waiting')
    % The GUI is still in UIWAIT, us UIRESUME
    uiresume(hObject);
else
    % The GUI is no longer waiting, just close it
    delete(hObject);
end


% --- Executes on button press in pushbuttonAzPlus.
function pushbuttonAzPlus_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonAzPlus (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles.axes1.View(1)=handles.axes1.View(1)+1;

% --- Executes on button press in pushbuttonAzMinus.
function pushbuttonAzMinus_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonAzMinus (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles.axes1.View(1)=handles.axes1.View(1)-1;

% --- Executes on button press in pushbuttonElPlus.
function pushbuttonElPlus_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonElPlus (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles.axes1.View(2)=handles.axes1.View(2)+1;

% --- Executes on button press in pushbuttonElMinus.
function pushbuttonElMinus_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonElMinus (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles.axes1.View(2)=handles.axes1.View(2)-1;

