function data = PILEDYN_preFILE(varargin)

    if ~exist('src_pre','dir')
        if isunix || ismac
            msg = 'Wrong path to src directory';
        elseif ispc
            msg = 'Wrong path to src folder';
        end
        error(msg);
    else
        src_path = fullfile(pwd,'src_pre');
    end

    addpath(src_path)
    
    if nargin==0
        data = MainFILE;
    else
        data = MainFILE(varargin{:});
    end

end
