function PILEDYN_pos(varargin)
    %% INPUT
    if length(varargin)~=4 && length(varargin)~=5
        error('Wrong input arguments.')
        return
    end

    fINP =         varargin{1};
    Path =         varargin{2};
    mus =          varargin{3};
    D =            varargin{4};

    plot_results = true;
    
    CaseName = FindCaseName(fINP);
    full_fINP = fullfile(Path,fINP);
    
    if ~exist(Path,'dir')
        error('Input file directory cannot be found')
        return
    end
    if length(varargin)==4
        vmode = 0;
        vmode_txt = logical(strfind(fINP,'.imp.txt'));
        vmode_x =  logical(strfind(fINP,'_x'));
        vmode_y =  logical(strfind(fINP,'_y'));
        vmode_z =  logical(strfind(fINP,'_z'));
        vmode_rx = logical(strfind(fINP,'_rx'));
        vmode_ry = logical(strfind(fINP,'_ry'));
        if ~isempty(vmode_txt) && ~isempty(vmode_x)
            vmode = 1;
        end
        if ~isempty(vmode_txt) && ~isempty(vmode_y)
            vmode = 2;
        end
        if ~isempty(vmode_txt) && ~isempty(vmode_z)
            vmode = 3;
        end
        if ~isempty(vmode_txt) && ~isempty(vmode_rx)
            vmode = 4;
        end
        if ~isempty(vmode_txt) && ~isempty(vmode_ry)
            vmode = 5;
        end
        if vmode==0
            fprintf('Generic input file name! \n');
            error('A vibration mode must be selected within input options.');
            return
        end
    else
        vmode = varargin{5};
        if vmode<1 || vmode>5
            error('Wrong vibration mode selected. Value must be 1, 2, 3, 4 or 5.')
            return
        end
    end

    [INP,open_error] = fopen(full_fINP,'r+');
    fm =  '%d %f %f %d %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f\n';
    INP_data = fscanf(INP,fm,[1 Inf]);
    fclose(INP);

    %% MAIN
    
    % (?) rows, 20 ids
    if mod(length(INP_data),20)~=0
        error('Error in file')
    end
    total_rows = length(INP_data)/20;

    for column = 1:total_rows
        id = 20*(column-1);

        freq(column) = INP_data(1+id);
        ao(column) =   INP_data(2+id);
        wref(column) = INP_data(3+id);
        lc(column) =   INP_data(4+id);

        f = freq(column);
        lcc = lc(column);
        xcoord_tip(f,lcc) = INP_data(5+id);
        ycoord_tip(f,lcc) = INP_data(6+id);
        zcoord_tip(f,lcc) = INP_data(7+id);

        xcoord_head(f,lcc) = INP_data( 8+id);
        ycoord_head(f,lcc) = INP_data( 9+id);
        zcoord_head(f,lcc) = INP_data(10+id);

        Fx(f,lcc) = INP_data(11+id) + i*INP_data(12+id);
        Fy(f,lcc) = INP_data(13+id) + i*INP_data(14+id);
        Fz(f,lcc) = INP_data(15+id) + i*INP_data(16+id);

        % My = +Mx' (momentum that produces ux=+1)
        % Mx = -My' (momentum that produces uy=+1)
        My(f,lcc) = +( INP_data(17+id) + i*INP_data(18+id) );
        Mx(f,lcc) = -( INP_data(19+id) + i*INP_data(20+id) );
    end
    pile = unique(lc);
    ao =   unique(ao);

    % (1)Kxx (2)Kyy (3)Kzz (4)Krx (5)Kry (6)Kryx (7)Krxy (8)Kxry (9)Kyrx
    switch vmode
        case 1; impedance = [1 6];
        case 2; impedance = [2 7];
        case 3; impedance = [3];
        case 4; impedance = [4 8];
        case 5; impedance = [5 9];
    end

    for imp = impedance
        if imp==1 || imp==2 || imp==3
            normalizer = mus * D;
            powerto = '';
        elseif imp==5 || imp==6
            normalizer = mus * D^3;
            powerto = '^3';
        else
            normalizer = mus * D^2;
            powerto = '^2';
        end

        switch imp
            case 1
                force = Fx;
                imp_subindex = 'xx';
            case 2
                force = Fy;
                imp_subindex = 'yy';
            case 3
                force = Fz;
                imp_subindex = 'zz';
            case 4
                momentum = Mx;
                coord = ycoord_head;
                force = Fz;
                imp_subindex = 'rx';
            case 5
                momentum = My;
                coord = xcoord_head;
                force = Fz;
                imp_subindex = 'ry';
            case 6
                momentum = My;
                coord = xcoord_head;
                force = Fz;
                imp_subindex = 'ryx';
            case 7
                momentum = Mx;
                coord = ycoord_head;
                force = Fz;
                imp_subindex = 'rxy';
            case 8
                force = Fx;
                imp_subindex = 'xry';
            case 9
                force = Fy;
                imp_subindex = 'yrx';
        end

        fOUP = fullfile(Path,strcat('K',imp_subindex,'.dat'));
        FigureTitle = strcat(CaseName,', K',imp_subindex);
        FigureName_jpg = fullfile(Path,strcat('K',imp_subindex,'.jpg'));
        FigureName_pdf = fullfile(Path,strcat('K',imp_subindex,'.pdf'));
        ylabel_Kabs =  strcat('|K_{',imp_subindex,'}/(\mu_{s} D',powerto,')|');
        ylabel_Kreal = strcat('k_{',imp_subindex,'}/(\mu_{s} D',powerto,')');
        ylabel_C =     strcat('c_{',imp_subindex,'}/(\mu_{s} D',powerto,')');

        K = zeros(length(unique(ao)),1);
        for id_ao = 1:length(unique(ao))
            for id_lc = pile
                switch imp
                    case {1,2,3,8,9}
                        if xcoord_head(id_lc)==0 && ycoord_head(id_lc)==0
                            K_added = force(id_ao,id_lc);
                        else
                            if xor(xcoord_head(id_lc)==0,ycoord_head(id_lc)==0)
                                K_added = 2*force(id_ao,id_lc);
                            else
                                K_added = 4*force(id_ao,id_lc);
                            end
                        end
                    case {4,5,6,7}
                        if xcoord_head(id_lc)==0 && ycoord_head(id_lc)==0
                            K_added = momentum(id_ao,id_lc);
                        else
                            if xor(xcoord_head(id_lc)==0,ycoord_head(id_lc)==0)
                                K_added = 2*(momentum(id_ao,id_lc) + coord(id_ao,id_lc)*force(id_ao,id_lc));
                            else
                                K_added = 4*(momentum(id_ao,id_lc) + coord(id_ao,id_lc)*force(id_ao,id_lc));
                            end
                        end
                end

                K(id_ao) = K(id_ao) + K_added;
            end
        end
        K = K / normalizer;
        

        %% OUTPUT

        OUP = fopen(fOUP,'w');
        for id_ao=1:length(ao)
            fprintf(OUP,'%f  %f  %f \n',ao(id_ao),real(K(id_ao)),imag(K(id_ao)/ao(id_ao)));
        end
        fclose(OUP);

        if logical(plot_results)
            minkij = min(real(K));
            maxkij = max(real(K));
            mincij = min(imag(K./ao'));
            maxcij = max(imag(K./ao'));
            minabskij = min(abs(K));
            maxabskij = max(abs(K));

            figure('Name',FigureTitle,'NumberTitle','off');
            ax = gca;
            H = subplot(2,2,1);
            plot(ao,real(K));
            xlabel('\omega D/c_{s}');
            ylabel(ylabel_Kreal);
            axis square;

            H = subplot(2,2,2);
            plot(ao,imag(K./ao'));
            xlabel('\omega D/c_{s}');
            ylabel(ylabel_C);
            axis square;

            H = subplot(2,2,[3 4]);
            plot(ao,abs(K));
            xlabel('\omega D/c_{s}');
            ylabel(ylabel_Kabs);
            axis square;

            saveas(H,FigureName_jpg);
            saveas(H,FigureName_pdf);
        end

    end

end

function CaseName = FindCaseName(FileName)
        [Path,Name] = fileparts(FileName);
        splited_name = strsplit(FileName,'.');
        CaseName = splited_name{1};
end
